/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocRequest;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resources.ResourceAccessHandler;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.setting.OpensearchDynamicSetting;

public class ResourceAccessEvaluator {
    private static final Logger log = LogManager.getLogger(ResourceAccessEvaluator.class);
    private final ResourcePluginInfo resourcePluginInfo;
    private final ResourceAccessHandler resourceAccessHandler;
    private final OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting;
    private final OpensearchDynamicSetting<List<String>> protectedResourceTypesSetting;

    public ResourceAccessEvaluator(ResourcePluginInfo resourcePluginInfo, ResourceAccessHandler resourceAccessHandler, OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting, OpensearchDynamicSetting<List<String>> protectedResourceTypesSetting) {
        this.resourcePluginInfo = resourcePluginInfo;
        this.resourceAccessHandler = resourceAccessHandler;
        this.resourceSharingEnabledSetting = resourceSharingEnabledSetting;
        this.protectedResourceTypesSetting = protectedResourceTypesSetting;
    }

    public void evaluateAsync(ActionRequest request, String action, ActionListener<PrivilegesEvaluatorResponse> pResponseListener) {
        log.debug("Evaluating resource access");
        DocRequest req = (DocRequest)request;
        this.resourceAccessHandler.hasPermission(req.id(), req.type(), action, (ActionListener<Boolean>)ActionListener.wrap(hasAccess -> {
            if (hasAccess.booleanValue()) {
                pResponseListener.onResponse((Object)PrivilegesEvaluatorResponse.ok());
            } else {
                pResponseListener.onResponse((Object)PrivilegesEvaluatorResponse.insufficient(action));
            }
        }, e -> pResponseListener.onResponse((Object)PrivilegesEvaluatorResponse.insufficient(action))));
    }

    public boolean shouldEvaluate(ActionRequest request) {
        boolean isResourceSharingFeatureEnabled = this.resourceSharingEnabledSetting.getDynamicSettingValue();
        List<String> protectedTypes = this.protectedResourceTypesSetting.getDynamicSettingValue();
        if (!isResourceSharingFeatureEnabled) {
            return false;
        }
        if (!(request instanceof DocRequest)) {
            return false;
        }
        DocRequest docRequest = (DocRequest)request;
        if (request instanceof GetRequest) {
            return false;
        }
        if (request instanceof DocWriteRequest) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)docRequest.id())) {
            log.debug("Request id is blank or null, request is of type {}", (Object)docRequest.getClass().getName());
            return false;
        }
        if (!this.resourcePluginInfo.getResourceIndicesForProtectedTypes().contains(docRequest.index())) {
            log.debug("Request index {} is not a protected resource index", (Object)docRequest.index());
            return false;
        }
        return protectedTypes.contains(docRequest.type());
    }
}

