/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JsonArrayBase;
import com.github.wnameless.json.base.JsonObjectBase;
import com.github.wnameless.json.base.JsonValueBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JsonValueUtils {
    private JsonValueUtils() {
    }

    public static Object toObject(JsonValueBase<?> jsonValue) {
        if (jsonValue.isNull()) {
            return jsonValue.asNull();
        }
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        if (jsonValue.isNumber()) {
            return jsonValue.asNumber();
        }
        if (jsonValue.isArray()) {
            return JsonValueUtils.toList(jsonValue.asArray());
        }
        if (jsonValue.isObject()) {
            return JsonValueUtils.toMap(jsonValue.asObject());
        }
        throw new IllegalStateException();
    }

    public static Number toJavaNumber(BigDecimal bd) {
        if (BigDecimal.valueOf(bd.intValue()).equals(bd)) {
            return bd.intValue();
        }
        if (BigDecimal.valueOf(bd.longValue()).equals(bd)) {
            return bd.longValue();
        }
        if (bd.scale() <= 0) {
            return bd.toBigInteger();
        }
        if (BigDecimal.valueOf(bd.doubleValue()).compareTo(bd) == 0) {
            return bd.doubleValue();
        }
        return bd;
    }

    public static List<Object> toList(JsonArrayBase<?> jsonArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonValueBase val : jsonArray) {
            list.add(JsonValueUtils.toObject(val));
        }
        return list;
    }

    public static Map<String, Object> toMap(JsonObjectBase<?> jsonObject) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator<String> names = jsonObject.names();
        while (names.hasNext()) {
            String name = names.next();
            Object val = jsonObject.get(name);
            map.put(name, JsonValueUtils.toObject(val));
        }
        return map;
    }
}

