/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.regex.Regex;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.tasks.TaskResultsService;

@ExperimentalApi
public class SystemIndexRegistry {
    private static final SystemIndexDescriptor TASK_INDEX_DESCRIPTOR = new SystemIndexDescriptor(".tasks*", "Task Result Index");
    private static final Map<String, Collection<SystemIndexDescriptor>> SERVER_SYSTEM_INDEX_DESCRIPTORS = Collections.singletonMap(TaskResultsService.class.getName(), Collections.singletonList(TASK_INDEX_DESCRIPTOR));
    private static volatile String[] SYSTEM_INDEX_PATTERNS = new String[0];
    private static volatile Map<String, Collection<SystemIndexDescriptor>> SYSTEM_INDEX_DESCRIPTORS_MAP = Collections.emptyMap();

    static void register(Map<String, Collection<SystemIndexDescriptor>> pluginAndModulesDescriptors) {
        Map<String, Collection<SystemIndexDescriptor>> descriptorsMap = SystemIndexRegistry.buildSystemIndexDescriptorMap(pluginAndModulesDescriptors);
        SystemIndexRegistry.checkForOverlappingPatterns(descriptorsMap);
        SYSTEM_INDEX_DESCRIPTORS_MAP = descriptorsMap;
        SYSTEM_INDEX_PATTERNS = (String[])SystemIndexRegistry.getAllDescriptors().stream().map(SystemIndexDescriptor::getIndexPattern).toArray(String[]::new);
    }

    public static Set<String> matchesSystemIndexPattern(Set<String> indexExpressions) {
        return indexExpressions.stream().filter(pattern -> Regex.simpleMatch(SYSTEM_INDEX_PATTERNS, pattern)).collect(Collectors.toSet());
    }

    public static boolean matchesSystemIndexPattern(String index) {
        return Regex.simpleMatch(SYSTEM_INDEX_PATTERNS, index);
    }

    public static Set<String> matchesPluginSystemIndexPattern(String pluginClassName, Set<String> indexExpressions) {
        if (!SYSTEM_INDEX_DESCRIPTORS_MAP.containsKey(pluginClassName)) {
            return Collections.emptySet();
        }
        String[] pluginSystemIndexPatterns = (String[])SYSTEM_INDEX_DESCRIPTORS_MAP.get(pluginClassName).stream().map(SystemIndexDescriptor::getIndexPattern).toArray(String[]::new);
        return indexExpressions.stream().filter(pattern -> Regex.simpleMatch(pluginSystemIndexPatterns, pattern)).collect(Collectors.toSet());
    }

    public static Predicate<String> getPluginSystemIndexPredicate(String pluginClassName) {
        Collection<SystemIndexDescriptor> systemIndexDescriptors = SYSTEM_INDEX_DESCRIPTORS_MAP.get(pluginClassName);
        if (systemIndexDescriptors == null || systemIndexDescriptors.isEmpty()) {
            return index -> false;
        }
        return index -> systemIndexDescriptors.stream().anyMatch(systemIndexDescriptor -> Regex.simpleMatch(systemIndexDescriptor.getIndexPattern(), index));
    }

    static List<SystemIndexDescriptor> getAllDescriptors() {
        return SYSTEM_INDEX_DESCRIPTORS_MAP.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    static void checkForOverlappingPatterns(Map<String, Collection<SystemIndexDescriptor>> sourceToDescriptors) {
        List<Tuple> sourceDescriptorPair = sourceToDescriptors.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(descriptor -> new Tuple((Object)((String)entry.getKey()), descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemIndexDescriptor)d.v2()).getIndexPattern())).collect(Collectors.toList());
        sourceDescriptorPair.forEach(descriptorToCheck -> {
            List descriptorsMatchingThisPattern = sourceDescriptorPair.stream().filter(d -> descriptorToCheck.v2() != d.v2()).filter(d -> SystemIndexRegistry.overlaps((SystemIndexDescriptor)descriptorToCheck.v2(), (SystemIndexDescriptor)d.v2())).collect(Collectors.toList());
            if (!descriptorsMatchingThisPattern.isEmpty()) {
                throw new IllegalStateException("a system index descriptor [" + String.valueOf(descriptorToCheck.v2()) + "] from [" + (String)descriptorToCheck.v1() + "] overlaps with other system index descriptors: [" + descriptorsMatchingThisPattern.stream().map(descriptor -> String.valueOf(descriptor.v2()) + " from [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
            }
        });
    }

    private static boolean overlaps(SystemIndexDescriptor a1, SystemIndexDescriptor a2) {
        Automaton a2Automaton;
        Automaton a1Automaton = Regex.simpleMatchToAutomaton(a1.getIndexPattern());
        return !Operations.isEmpty((Automaton)Operations.intersection((Automaton)a1Automaton, (Automaton)(a2Automaton = Regex.simpleMatchToAutomaton(a2.getIndexPattern()))));
    }

    private static Map<String, Collection<SystemIndexDescriptor>> buildSystemIndexDescriptorMap(Map<String, Collection<SystemIndexDescriptor>> pluginAndModulesMap) {
        HashMap<String, Collection<SystemIndexDescriptor>> map = new HashMap<String, Collection<SystemIndexDescriptor>>(pluginAndModulesMap.size() + SERVER_SYSTEM_INDEX_DESCRIPTORS.size());
        map.putAll(pluginAndModulesMap);
        SERVER_SYSTEM_INDEX_DESCRIPTORS.forEach((source, descriptors) -> {
            if (map.putIfAbsent((String)source, (Collection<SystemIndexDescriptor>)descriptors) != null) {
                throw new IllegalArgumentException("plugin or module attempted to define the same source [" + source + "] as a built-in system index");
            }
        });
        return Collections.unmodifiableMap(map);
    }
}

