/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.jcajce.spec.KTSKeySpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KTSGenerateKeySpec
extends KTSKeySpec {
    private final PublicKey publicKey;
    private final SecureRandom random;

    private KTSGenerateKeySpec(PublicKey publicKey, String string, int n, SecureRandom secureRandom, String string2, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2) {
        super(string, n, string2, n2, algorithmParameterSpec, algorithmIdentifier, byArray, byArray2);
        this.publicKey = publicKey;
        this.random = secureRandom;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public SecureRandom getSecureRandom() {
        return this.random;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Builder {
        private final PublicKey publicKey;
        private final String algorithmName;
        private final int keySizeInBits;
        private String macAlgorithm;
        private int macKeySizeInBits;
        private SecureRandom random;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;
        private byte[] otherInfo;
        private byte[] salt;

        public Builder(PublicKey publicKey, String string, int n) {
            this(publicKey, string, n, null);
        }

        public Builder(PublicKey publicKey, String string, int n, byte[] byArray) {
            this.publicKey = publicKey;
            this.algorithmName = string;
            this.keySizeInBits = n;
            this.kdfAlgorithm = KTSKeySpec.createAlgId(KTSKeySpec.KDF3.withPRF(FipsKDF.AgreementKDFPRF.SHA256));
            this.otherInfo = KTSKeySpec.copyOtherInfo(byArray);
        }

        public Builder withSecureRandom(SecureRandom secureRandom) {
            this.random = secureRandom;
            return this;
        }

        public Builder withMac(String string, int n) {
            this.macAlgorithm = string;
            this.macKeySizeInBits = n;
            if (string != null && n <= 0) {
                throw new IllegalArgumentException("macKeySizeInBits must be greater than zero");
            }
            return this;
        }

        public Builder withParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            this.parameterSpec = algorithmParameterSpec;
            return this;
        }

        public Builder withKdfAlgorithm(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
            this.kdfAlgorithm = KTSKeySpec.createAlgId(agreementKDFParametersBuilder);
            return this;
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
            this.kdfAlgorithm = algorithmIdentifier;
            return this;
        }

        public Builder withKdfSalt(byte[] byArray) {
            this.salt = byArray;
            return this;
        }

        public KTSGenerateKeySpec build() {
            return new KTSGenerateKeySpec(this.publicKey, this.algorithmName, this.keySizeInBits, this.random, this.macAlgorithm, this.macKeySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo, this.salt);
        }
    }
}

