/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractNamedDiffable;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.RepositoryOperation;
import org.opensearch.repositories.RepositoryShardId;
import org.opensearch.snapshots.InFlightShardSnapshotStates;
import org.opensearch.snapshots.Snapshot;
import org.opensearch.snapshots.SnapshotId;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotsInProgress EMPTY = new SnapshotsInProgress(Collections.emptyList());
    public static final String TYPE = "snapshots";
    public static final String ABORTED_FAILURE_TEXT = "Snapshot was aborted by deletion";
    private final List<Entry> entries;
    private static final String REPOSITORY = "repository";
    private static final String SNAPSHOTS = "snapshots";
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final String PARTIAL = "partial";
    private static final String STATE = "state";
    private static final String INDICES = "indices";
    private static final String DATA_STREAMS = "data_streams";
    private static final String START_TIME_MILLIS = "start_time_millis";
    private static final String START_TIME = "start_time";
    private static final String REPOSITORY_STATE_ID = "repository_state_id";
    private static final String SHARDS = "shards";
    private static final String INDEX = "index";
    private static final String SHARD = "shard";
    private static final String NODE = "node";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entries.equals(((SnapshotsInProgress)o).entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).snapshot().getSnapshotId().getName());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static Entry startedEntry(Snapshot snapshot, boolean includeGlobalState, boolean partial, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version, boolean remoteStoreIndexShallowCopy) {
        return new Entry(snapshot, includeGlobalState, partial, SnapshotsInProgress.completed(shards.values()) ? State.SUCCESS : State.STARTED, indices, dataStreams, startTime, repositoryStateId, shards, null, userMetadata, version, remoteStoreIndexShallowCopy);
    }

    public static Entry startedEntry(Snapshot snapshot, boolean includeGlobalState, boolean partial, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version, boolean remoteStoreIndexShallowCopy, boolean remoteStoreIndexShallowCopyV2) {
        return new Entry(snapshot, includeGlobalState, partial, SnapshotsInProgress.completed(shards.values()) ? State.SUCCESS : State.STARTED, indices, dataStreams, startTime, repositoryStateId, shards, null, userMetadata, version, remoteStoreIndexShallowCopy, remoteStoreIndexShallowCopyV2);
    }

    public static Entry startClone(Snapshot snapshot, SnapshotId source, List<IndexId> indices, long startTime, long repositoryStateId, Version version) {
        return new Entry(snapshot, true, false, State.STARTED, indices, Collections.emptyList(), startTime, repositoryStateId, Map.of(), null, Collections.emptyMap(), version, source, Map.of(), false, false);
    }

    public static Entry startClone(Snapshot snapshot, SnapshotId source, List<IndexId> indices, long startTime, long repositoryStateId, Version version, boolean remoteStoreIndexShallowCopyV2) {
        return new Entry(snapshot, true, false, State.STARTED, indices, Collections.emptyList(), startTime, repositoryStateId, Map.of(), null, Collections.emptyMap(), version, source, Map.of(), remoteStoreIndexShallowCopyV2, remoteStoreIndexShallowCopyV2);
    }

    public static boolean completed(Collection<ShardSnapshotStatus> shards) {
        for (ShardSnapshotStatus status : shards) {
            if (status.state().completed) continue;
            return false;
        }
        return true;
    }

    private static boolean hasFailures(Map<RepositoryShardId, ShardSnapshotStatus> clones) {
        for (ShardSnapshotStatus value : clones.values()) {
            if (!value.state().failed()) continue;
            return true;
        }
        return false;
    }

    private static boolean assertConsistentEntries(List<Entry> entries) {
        HashMap<String, Set> assignedShardsByRepo = new HashMap<String, Set>();
        for (Entry entry : entries) {
            for (Map.Entry<ShardId, ShardSnapshotStatus> shard : entry.shards().entrySet()) {
                if (shard.getValue().isActive()) assert (assignedShardsByRepo.computeIfAbsent(entry.repository(), k -> new HashSet()).add(shard.getKey())) : "Found duplicate shard assignments in " + String.valueOf(entries);
            }
        }
        for (String repoName : assignedShardsByRepo.keySet()) {
            InFlightShardSnapshotStates.forRepo(repoName, entries);
        }
        return true;
    }

    public static SnapshotsInProgress of(List<Entry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return new SnapshotsInProgress(Collections.unmodifiableList(entries));
    }

    private SnapshotsInProgress(List<Entry> entries) {
        this.entries = entries;
        assert (SnapshotsInProgress.assertConsistentEntries(entries));
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(Snapshot snapshot) {
        for (Entry entry : this.entries) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    public String getWriteableName() {
        return "snapshots";
    }

    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, "snapshots", in);
    }

    public SnapshotsInProgress(StreamInput in) throws IOException {
        this.entries = in.readList(Entry::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.entries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries) {
            entry.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static class Entry
    implements Writeable,
    ToXContent,
    RepositoryOperation {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean remoteStoreIndexShallowCopy;
        private final boolean remoteStoreIndexShallowCopyV2;
        private final boolean partial;
        private final Map<ShardId, ShardSnapshotStatus> shards;
        private final List<IndexId> indices;
        private final List<String> dataStreams;
        private final long startTime;
        private final long repositoryStateId;
        private final Version version;
        @Nullable
        private final SnapshotId source;
        private final Map<RepositoryShardId, ShardSnapshotStatus> clones;
        @Nullable
        private final Map<String, Object> userMetadata;
        @Nullable
        private final String failure;

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version, boolean remoteStoreIndexShallowCopy, boolean remoteStoreIndexShallowCopyV2) {
            this(snapshot, includeGlobalState, partial, state, indices, dataStreams, startTime, repositoryStateId, shards, failure, userMetadata, version, null, Map.of(), remoteStoreIndexShallowCopy, remoteStoreIndexShallowCopyV2);
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version, boolean remoteStoreIndexShallowCopy) {
            this(snapshot, includeGlobalState, partial, state, indices, dataStreams, startTime, repositoryStateId, shards, failure, userMetadata, version, null, Map.of(), remoteStoreIndexShallowCopy, false);
        }

        private Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, Version version, @Nullable SnapshotId source, @Nullable Map<RepositoryShardId, ShardSnapshotStatus> clones, boolean remoteStoreIndexShallowCopy, boolean remoteStoreIndexShallowCopyV2) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = indices;
            this.dataStreams = dataStreams;
            this.startTime = startTime;
            this.shards = Collections.unmodifiableMap(shards);
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
            this.userMetadata = userMetadata;
            this.version = version;
            this.source = source;
            if (source == null) {
                assert (clones == null || clones.isEmpty()) : "Provided [" + String.valueOf(clones) + "] but no source";
                this.clones = Map.of();
            } else {
                this.clones = Collections.unmodifiableMap(clones);
            }
            this.remoteStoreIndexShallowCopy = remoteStoreIndexShallowCopy;
            this.remoteStoreIndexShallowCopyV2 = remoteStoreIndexShallowCopyV2;
            assert (this.remoteStoreIndexShallowCopyV2 || Entry.assertShardsConsistent(this.source, this.state, this.indices, this.shards, this.clones));
        }

        private Entry(StreamInput in) throws IOException {
            this.snapshot = new Snapshot(in);
            this.includeGlobalState = in.readBoolean();
            this.partial = in.readBoolean();
            this.state = State.fromValue(in.readByte());
            this.indices = in.readList(IndexId::new);
            this.startTime = in.readLong();
            this.shards = in.readMap(ShardId::new, ShardSnapshotStatus::readFrom);
            this.repositoryStateId = in.readLong();
            this.failure = in.readOptionalString();
            this.userMetadata = in.readMap();
            this.version = in.readVersion();
            this.dataStreams = in.readStringList();
            this.source = (SnapshotId)in.readOptionalWriteable(SnapshotId::new);
            this.clones = in.readMap(RepositoryShardId::new, ShardSnapshotStatus::readFrom);
            this.remoteStoreIndexShallowCopy = in.getVersion().onOrAfter(Version.V_2_9_0) ? in.readBoolean() : false;
            this.remoteStoreIndexShallowCopyV2 = in.getVersion().onOrAfter(Version.V_2_18_0) ? in.readBoolean() : false;
        }

        private static boolean assertShardsConsistent(SnapshotId source, State state, List<IndexId> indices, Map<ShardId, ShardSnapshotStatus> shards, Map<RepositoryShardId, ShardSnapshotStatus> clones) {
            boolean shardsCompleted;
            if ((state == State.INIT || state == State.ABORTED) && shards.isEmpty()) {
                return true;
            }
            Set indexNames = indices.stream().map(IndexId::getName).collect(Collectors.toSet());
            HashSet indexNamesInShards = new HashSet();
            shards.entrySet().forEach(s -> {
                indexNamesInShards.add(((ShardId)s.getKey()).getIndexName());
                assert (source == null || ((ShardSnapshotStatus)s.getValue()).nodeId == null) : "Shard snapshot must not be assigned to data node when copying from snapshot [" + String.valueOf(source) + "]";
            });
            assert (source == null || !indexNames.isEmpty()) : "No empty snapshot clones allowed";
            assert (source != null || indexNames.equals(indexNamesInShards)) : "Indices in shards " + String.valueOf(indexNamesInShards) + " differ from expected indices " + String.valueOf(indexNames) + " for state [" + String.valueOf((Object)state) + "]";
            boolean bl = shardsCompleted = SnapshotsInProgress.completed(shards.values()) && SnapshotsInProgress.completed(clones.values());
            if (source == null || !clones.isEmpty()) assert (state.completed() && shardsCompleted || !state.completed() && !shardsCompleted) : "Completed state must imply all shards completed but saw state [" + String.valueOf((Object)state) + "] and shards " + String.valueOf(shards);
            if (source != null && state.completed()) assert (!SnapshotsInProgress.hasFailures(clones) || state == State.FAILED) : "Failed shard clones in [" + String.valueOf(clones) + "] but state was [" + String.valueOf((Object)state) + "]";
            return true;
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, Version version, boolean remoteStoreIndexShallowCopy) {
            this(snapshot, includeGlobalState, partial, state, indices, dataStreams, startTime, repositoryStateId, shards, null, userMetadata, version, remoteStoreIndexShallowCopy);
        }

        public Entry(Entry entry, State state, List<IndexId> indices, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, Version version, String failure) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, indices, entry.dataStreams, entry.startTime, repositoryStateId, shards, failure, entry.userMetadata, version, entry.remoteStoreIndexShallowCopy);
        }

        public Entry withRepoGen(long newRepoGen) {
            assert (newRepoGen > this.repositoryStateId) : "Updated repository generation [" + newRepoGen + "] must be higher than current generation [" + this.repositoryStateId + "]";
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.startTime, newRepoGen, this.shards, this.failure, this.userMetadata, this.version, this.source, this.clones, this.remoteStoreIndexShallowCopy, this.remoteStoreIndexShallowCopyV2);
        }

        public Entry withClones(Map<RepositoryShardId, ShardSnapshotStatus> updatedClones) {
            if (updatedClones.equals(this.clones)) {
                return this;
            }
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, SnapshotsInProgress.completed(updatedClones.values()) ? (SnapshotsInProgress.hasFailures(updatedClones) ? State.FAILED : State.SUCCESS) : this.state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, this.shards, this.failure, this.userMetadata, this.version, this.source, updatedClones, this.remoteStoreIndexShallowCopy, this.remoteStoreIndexShallowCopyV2);
        }

        public Entry withRemoteStoreIndexShallowCopy(boolean remoteStoreIndexShallowCopy) {
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, this.shards, this.failure, this.userMetadata, this.version, this.source, this.clones, remoteStoreIndexShallowCopy, this.remoteStoreIndexShallowCopyV2);
        }

        @Nullable
        public Entry abort() {
            HashMap<ShardId, ShardSnapshotStatus> shardsBuilder = new HashMap<ShardId, ShardSnapshotStatus>();
            boolean completed = true;
            boolean allQueued = true;
            for (Map.Entry<ShardId, ShardSnapshotStatus> shardEntry : this.shards.entrySet()) {
                ShardSnapshotStatus status = shardEntry.getValue();
                allQueued &= status.state() == ShardState.QUEUED;
                if (!status.state().completed()) {
                    String nodeId;
                    status = new ShardSnapshotStatus(nodeId, (nodeId = status.nodeId()) == null ? ShardState.FAILED : ShardState.ABORTED, "aborted by snapshot deletion", status.generation());
                }
                completed &= status.state().completed();
                shardsBuilder.put(shardEntry.getKey(), status);
            }
            if (allQueued) {
                return null;
            }
            return this.fail(shardsBuilder, completed ? State.SUCCESS : State.ABORTED, SnapshotsInProgress.ABORTED_FAILURE_TEXT);
        }

        public Entry fail(Map<ShardId, ShardSnapshotStatus> shards, State state, String failure) {
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, shards, failure, this.userMetadata, this.version, this.source, this.clones, this.remoteStoreIndexShallowCopy, this.remoteStoreIndexShallowCopyV2);
        }

        public Entry withShardStates(Map<ShardId, ShardSnapshotStatus> shards) {
            if (SnapshotsInProgress.completed(shards.values())) {
                return new Entry(this.snapshot, this.includeGlobalState, this.partial, State.SUCCESS, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version, this.remoteStoreIndexShallowCopy);
            }
            return this.withStartedShards(shards);
        }

        public Entry withStartedShards(Map<ShardId, ShardSnapshotStatus> shards) {
            Entry updated = new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version, this.remoteStoreIndexShallowCopy);
            assert (!updated.state().completed() && !SnapshotsInProgress.completed(updated.shards().values())) : "Only running snapshots allowed but saw [" + String.valueOf(updated) + "]";
            return updated;
        }

        @Override
        public String repository() {
            return this.snapshot.getRepository();
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public Map<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<IndexId> indices() {
            return this.indices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean remoteStoreIndexShallowCopy() {
            return this.remoteStoreIndexShallowCopy;
        }

        public boolean remoteStoreIndexShallowCopyV2() {
            return this.remoteStoreIndexShallowCopyV2;
        }

        public Map<String, Object> userMetadata() {
            return this.userMetadata;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        public List<String> dataStreams() {
            return this.dataStreams;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public Version version() {
            return this.version;
        }

        @Nullable
        public SnapshotId source() {
            return this.source;
        }

        public boolean isClone() {
            return this.source != null;
        }

        public Map<RepositoryShardId, ShardSnapshotStatus> clones() {
            return this.clones;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (this.repositoryStateId != entry.repositoryStateId) {
                return false;
            }
            if (!this.version.equals((Object)entry.version)) {
                return false;
            }
            if (!Objects.equals(this.source, ((Entry)o).source)) {
                return false;
            }
            if (!this.clones.equals(((Entry)o).clones)) {
                return false;
            }
            if (this.remoteStoreIndexShallowCopy != entry.remoteStoreIndexShallowCopy) {
                return false;
            }
            return this.remoteStoreIndexShallowCopyV2 == entry.remoteStoreIndexShallowCopyV2;
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            result = 31 * result + this.version.hashCode();
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + this.clones.hashCode();
            result = 31 * result + (this.remoteStoreIndexShallowCopy ? 1 : 0);
            result = 31 * result + (this.remoteStoreIndexShallowCopyV2 ? 1 : 0);
            return result;
        }

        public String toString() {
            return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SnapshotsInProgress.REPOSITORY, this.snapshot.getRepository());
            builder.field(SnapshotsInProgress.SNAPSHOT, this.snapshot.getSnapshotId().getName());
            builder.field(SnapshotsInProgress.UUID, this.snapshot.getSnapshotId().getUUID());
            builder.field(SnapshotsInProgress.INCLUDE_GLOBAL_STATE, this.includeGlobalState());
            builder.field(SnapshotsInProgress.PARTIAL, this.partial);
            builder.field(SnapshotsInProgress.STATE, (Object)this.state);
            builder.startArray(SnapshotsInProgress.INDICES);
            for (IndexId indexId : this.indices) {
                indexId.toXContent(builder, params);
            }
            builder.endArray();
            builder.humanReadableField(SnapshotsInProgress.START_TIME_MILLIS, SnapshotsInProgress.START_TIME, (Object)new TimeValue(this.startTime));
            builder.field(SnapshotsInProgress.REPOSITORY_STATE_ID, this.repositoryStateId);
            builder.startArray(SnapshotsInProgress.SHARDS);
            for (Map.Entry entry : this.shards.entrySet()) {
                ShardId shardId = (ShardId)entry.getKey();
                ShardSnapshotStatus status = (ShardSnapshotStatus)entry.getValue();
                builder.startObject();
                builder.field(SnapshotsInProgress.INDEX, (ToXContent)shardId.getIndex());
                builder.field(SnapshotsInProgress.SHARD, shardId.getId());
                builder.field(SnapshotsInProgress.STATE, (Object)status.state());
                builder.field(SnapshotsInProgress.NODE, status.nodeId());
                builder.endObject();
            }
            builder.endArray();
            builder.array(SnapshotsInProgress.DATA_STREAMS, this.dataStreams.toArray(new String[0]));
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.snapshot.writeTo(out);
            out.writeBoolean(this.includeGlobalState);
            out.writeBoolean(this.partial);
            if (out.getVersion().before(Version.V_2_14_0) && this.state == State.PARTIAL) {
                out.writeByte(State.SUCCESS.value());
            } else {
                out.writeByte(this.state.value());
            }
            out.writeList(this.indices);
            out.writeLong(this.startTime);
            out.writeMap(this.shards, (o, v) -> v.writeTo(o), (o, v) -> v.writeTo(o));
            out.writeLong(this.repositoryStateId);
            out.writeOptionalString(this.failure);
            out.writeMap(this.userMetadata);
            out.writeVersion(this.version);
            out.writeStringCollection(this.dataStreams);
            out.writeOptionalWriteable((Writeable)this.source);
            out.writeMap(this.clones, (o, v) -> v.writeTo(o), (o, v) -> v.writeTo(o));
            if (out.getVersion().onOrAfter(Version.V_2_9_0)) {
                out.writeBoolean(this.remoteStoreIndexShallowCopy);
            }
            if (out.getVersion().onOrAfter(Version.V_2_18_0)) {
                out.writeBoolean(this.remoteStoreIndexShallowCopyV2);
            }
        }

        public boolean isFragment() {
            return false;
        }
    }

    @PublicApi(since="1.0.0")
    public static enum State {
        INIT(0, false),
        STARTED(1, false),
        SUCCESS(2, true),
        FAILED(3, true),
        ABORTED(4, false),
        PARTIAL(5, false);

        private final byte value;
        private final boolean completed;

        private State(byte value, boolean completed) {
            this.value = value;
            this.completed = completed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return PARTIAL;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardSnapshotStatus
    implements Writeable {
        public static final ShardSnapshotStatus UNASSIGNED_QUEUED = new ShardSnapshotStatus(null, ShardState.QUEUED, null);
        public static final ShardSnapshotStatus MISSING = new ShardSnapshotStatus(null, ShardState.MISSING, "missing index", null);
        private final ShardState state;
        @Nullable
        private final String nodeId;
        @Nullable
        private final String generation;
        @Nullable
        private final String reason;

        public ShardSnapshotStatus(String nodeId, String generation) {
            this(nodeId, ShardState.INIT, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable String generation) {
            this(nodeId, state, null, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, String reason, @Nullable String generation) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            this.generation = generation;
            assert (this.assertConsistent());
        }

        private boolean assertConsistent() {
            assert (!this.state.failed() || this.reason != null);
            assert (this.state != ShardState.INIT && this.state != ShardState.WAITING || this.nodeId != null) : "Null node id for state [" + String.valueOf((Object)this.state) + "]";
            return true;
        }

        public static ShardSnapshotStatus readFrom(StreamInput in) throws IOException {
            String nodeId = in.readOptionalString();
            ShardState state = ShardState.fromValue(in.readByte());
            String generation = in.readOptionalString();
            String reason = in.readOptionalString();
            if (state == ShardState.QUEUED) {
                return UNASSIGNED_QUEUED;
            }
            return new ShardSnapshotStatus(nodeId, state, reason, generation);
        }

        public ShardState state() {
            return this.state;
        }

        @Nullable
        public String nodeId() {
            return this.nodeId;
        }

        @Nullable
        public String generation() {
            return this.generation;
        }

        public String reason() {
            return this.reason;
        }

        public boolean isActive() {
            return this.state == ShardState.INIT || this.state == ShardState.ABORTED || this.state == ShardState.WAITING;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.generation);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            return Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason) && Objects.equals(this.generation, status.generation) && this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShardSnapshotStatus[state=" + String.valueOf((Object)this.state) + ", nodeId=" + this.nodeId + ", reason=" + this.reason + ", generation=" + this.generation + "]";
        }
    }

    public static enum ShardState {
        INIT(0, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false),
        QUEUED(7, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private ShardState(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static ShardState fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
                case 7: {
                    return QUEUED;
                }
            }
            throw new IllegalArgumentException("No shard snapshot state for value [" + value + "]");
        }
    }
}

