/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.fieldcaps;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.query.QueryBuilder;

public class FieldCapabilitiesIndexRequest
extends ActionRequest
implements IndicesRequest {
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    private final String index;
    private final String[] fields;
    private final OriginalIndices originalIndices;
    private final QueryBuilder indexFilter;
    private final long nowInMillis;
    private ShardId shardId;

    FieldCapabilitiesIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = (ShardId)in.readOptionalWriteable(ShardId::new);
        this.index = in.readOptionalString();
        this.fields = in.readStringArray();
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.indexFilter = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nowInMillis = in.readLong();
    }

    FieldCapabilitiesIndexRequest(String[] fields, String index, OriginalIndices originalIndices, QueryBuilder indexFilter, long nowInMillis) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("specified fields can't be null or empty");
        }
        this.index = Objects.requireNonNull(index);
        this.fields = fields;
        this.originalIndices = originalIndices;
        this.indexFilter = indexFilter;
        this.nowInMillis = nowInMillis;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    public String index() {
        return this.index;
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    FieldCapabilitiesIndexRequest shardId(ShardId shardId) {
        this.shardId = shardId;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.shardId);
        out.writeOptionalString(this.index);
        out.writeStringArray(this.fields);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalNamedWriteable((NamedWriteable)this.indexFilter);
        out.writeLong(this.nowInMillis);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

