/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.html.editor.HtmlExtensions;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzer;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.foreign.UndeclaredContentResolver;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public class HtmlGSFParser
extends Parser {
    private static final Logger TIMER = Logger.getLogger("TIMER.j2ee.parser");
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private SyntaxAnalyzerResult result;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.parse(snapshot, event);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        SyntaxAnalyzerResult sar = this.result;
        return this.cancelled.get() || sar == null ? null : HtmlParserResultAccessor.get().createInstance(sar);
    }

    public void cancel(Parser.CancelReason reason, SourceModificationEvent event) {
        if (Parser.CancelReason.SOURCE_MODIFICATION_EVENT == reason && event.sourceChanged()) {
            this.cancelled.set(true);
            this.result = null;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private void parse(Snapshot snapshot, SourceModificationEvent event) {
        this.cancelled.set(false);
        if (snapshot == null) {
            return;
        }
        HtmlSource source = new HtmlSource(snapshot);
        Source snapshotSource = snapshot.getSource();
        String sourceMimetype = snapshotSource != null ? snapshotSource.getMimeType() : snapshot.getMimeType();
        Collection<? extends HtmlExtension> exts = HtmlExtensions.getRegisteredExtensions(sourceMimetype);
        if (this.cancelled.get()) {
            return;
        }
        ArrayList<UndeclaredContentResolver> resolvers = new ArrayList<UndeclaredContentResolver>();
        for (final HtmlExtension htmlExtension : exts) {
            resolvers.add(new UndeclaredContentResolver(){
                final /* synthetic */ HtmlGSFParser this$0;
                {
                    this.this$0 = this$0;
                }

                public Map<String, List<String>> getUndeclaredNamespaces(HtmlSource source) {
                    return htmlExtension.getUndeclaredNamespaces(source);
                }

                public boolean isCustomTag(Named element, HtmlSource source) {
                    return htmlExtension.isCustomTag(element, source);
                }

                public boolean isCustomAttribute(Attribute attribute, HtmlSource source) {
                    return htmlExtension.isCustomAttribute(attribute, source);
                }
            });
        }
        if (this.cancelled.get()) {
            return;
        }
        this.result = SyntaxAnalyzer.create((HtmlSource)source).analyze((UndeclaredContentResolver)new AggregatedUndeclaredContentResolver(resolvers));
        if (TIMER.isLoggable(Level.FINE)) {
            LogRecord rec = new LogRecord(Level.FINE, "HTML parse result");
            rec.setParameters(new Object[]{this.result});
            TIMER.log(rec);
        }
    }

    private static class AggregatedUndeclaredContentResolver
    implements UndeclaredContentResolver {
        private final Collection<UndeclaredContentResolver> resolvers;

        public AggregatedUndeclaredContentResolver(Collection<UndeclaredContentResolver> resolvers) {
            this.resolvers = resolvers;
        }

        public Map<String, List<String>> getUndeclaredNamespaces(HtmlSource source) {
            HashMap<String, List<String>> aggregated = new HashMap<String, List<String>>();
            for (UndeclaredContentResolver resolver : this.resolvers) {
                aggregated.putAll(resolver.getUndeclaredNamespaces(source));
            }
            return aggregated;
        }

        public boolean isCustomTag(Named element, HtmlSource source) {
            for (UndeclaredContentResolver r : this.resolvers) {
                if (!r.isCustomTag(element, source)) continue;
                return true;
            }
            return false;
        }

        public boolean isCustomAttribute(Attribute attr, HtmlSource source) {
            for (UndeclaredContentResolver r : this.resolvers) {
                if (!r.isCustomAttribute(attr, source)) continue;
                return true;
            }
            return false;
        }
    }
}

