/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jsui.frames.models;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.modules.debugger.jpda.js.frames.JSStackFrame;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.datatransfer.PasteType;

public class DebuggingJSNodeModel
implements ExtendedNodeModelFilter {
    private static final String SCRIPT_CLASS_PREFIX = "Script$";
    private static final String SCRIPT_CLASS_IN_HTML = ">Script$";
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private ModelListener listenerToOriginal;
    private final Object listenerToOriginalLock = new Object();

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canRename(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCut(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return original.getPasteTypes(node, t);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        original.setName(node, name);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSStackFrame) {
            node = ((JSStackFrame)node).getJavaFrame();
        }
        return original.getIconBaseWithExtension(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        String descr;
        if (node instanceof JSStackFrame) {
            Object object = this.listenerToOriginalLock;
            synchronized (object) {
                if (this.listenerToOriginal == null) {
                    this.listenerToOriginal = new OriginalModelListener();
                    original.addModelListener(this.listenerToOriginal);
                }
            }
            CallStackFrame javaFrame = ((JSStackFrame)node).getJavaFrame();
            descr = original.getDisplayName((Object)javaFrame);
            String nashornScriptClass = "jdk.nashorn.internal.scripts.Script$";
            int i = descr.indexOf(nashornScriptClass);
            if (i < 0) {
                nashornScriptClass = "org.openjdk.nashorn.internal.scripts.Script$";
                i = descr.indexOf(nashornScriptClass);
            }
            int i2 = 0;
            if (i < 0) {
                if (descr.startsWith(SCRIPT_CLASS_PREFIX)) {
                    i = 0;
                    i2 = SCRIPT_CLASS_PREFIX.length();
                } else {
                    i = descr.indexOf(SCRIPT_CLASS_IN_HTML);
                    if (i > 0) {
                        i2 = i + SCRIPT_CLASS_IN_HTML.length();
                        ++i;
                    }
                }
            } else {
                i2 = i + nashornScriptClass.length();
            }
            if (i >= 0) {
                descr = descr.substring(0, i) + descr.substring(i2);
            } else if (descr.startsWith("<html>")) {
                int end = descr.indexOf("</");
                int begin = descr.lastIndexOf(62, end);
                descr = descr.substring(0, ++begin) + DebuggingJSNodeModel.stripParentPath(descr.substring(begin, end)) + descr.substring(end);
            } else {
                descr = DebuggingJSNodeModel.stripParentPath(descr);
            }
        } else {
            descr = original.getDisplayName(node);
        }
        return descr;
    }

    private static String stripParentPath(String descr) {
        int slash = descr.lastIndexOf(File.separatorChar);
        if (File.separatorChar != '/') {
            int slash2 = descr.lastIndexOf(47);
            slash = Math.max(slash, slash2);
        }
        if (slash > 0) {
            descr = descr.substring(slash + 1);
        }
        return descr;
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSStackFrame) {
            return original.getIconBase((Object)((JSStackFrame)node).getJavaFrame());
        }
        return original.getIconBase(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSStackFrame) {
            return original.getShortDescription((Object)((JSStackFrame)node).getJavaFrame());
        }
        return original.getShortDescription(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelEvent(ModelEvent event) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener ml : ls) {
            ml.modelChanged(event);
        }
    }

    private class OriginalModelListener
    implements ModelListener {
        private OriginalModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            JSStackFrame jsFrame;
            ModelEvent.TableValueChanged tch;
            Object node;
            if (event instanceof ModelEvent.NodeChanged) {
                JSStackFrame jsFrame2;
                ModelEvent.NodeChanged nch = (ModelEvent.NodeChanged)event;
                Object node2 = nch.getNode();
                if (node2 instanceof CallStackFrame && (jsFrame2 = JSStackFrame.getExisting((CallStackFrame)((CallStackFrame)node2))) != null) {
                    event = new ModelEvent.NodeChanged((Object)DebuggingJSNodeModel.this, (Object)jsFrame2, nch.getChange());
                    DebuggingJSNodeModel.this.fireModelEvent(event);
                }
            } else if (event instanceof ModelEvent.TableValueChanged && (node = (tch = (ModelEvent.TableValueChanged)event).getNode()) instanceof CallStackFrame && (jsFrame = JSStackFrame.getExisting((CallStackFrame)((CallStackFrame)node))) != null) {
                event = new ModelEvent.TableValueChanged((Object)DebuggingJSNodeModel.this, (Object)jsFrame, tch.getColumnID(), tch.getChange());
                DebuggingJSNodeModel.this.fireModelEvent(event);
            }
        }
    }
}

