/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class IncorrectStaticContextHintError
extends HintErrorRule {
    private static final boolean DISABLED = Boolean.getBoolean("nb.php.editor.disableIncorrectStaticContextHintError");
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.IncorrectStaticContextHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        if (DISABLED) {
            return;
        }
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            Set<Variable> incorrectThisVariables = checkVisitor.getThisVariableInStaticContext();
            this.addIncorrectThisHints(incorrectThisVariables, hints);
        }
    }

    private void addIncorrectThisHints(Set<Variable> incorrectThisVariables, List<Hint> hints) {
        for (Variable thisVariable : incorrectThisVariables) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addHint(thisVariable, Bundle.IncorrectStaticContextHintError_incorrectThis(), hints);
        }
    }

    private void addHint(ASTNode node, String description, List<Hint> hints) {
        this.addHint(node, description, hints, Collections.emptyList());
    }

    private void addHint(ASTNode node, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), fixes, 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private boolean isInTypeDeclaration = false;
        private boolean isInStaticMethod = false;
        private ASTNode firstStaticClosure = null;
        private final ArrayDeque<ASTNode> firstStaticClosureStack = new ArrayDeque();
        private final ArrayDeque<Boolean> isInStaticMethodStack = new ArrayDeque();
        private final Set<Variable> thisVariableInStaticContext = new HashSet<Variable>();

        private CheckVisitor() {
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.isInStaticMethod = BodyDeclaration.Modifier.isStatic(node.getModifier());
            super.visit(node);
            this.isInStaticMethod = false;
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isStatic() && this.firstStaticClosure == null) {
                this.firstStaticClosure = node;
            }
            super.visit(node);
            if (this.firstStaticClosure == node) {
                this.firstStaticClosure = null;
            }
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isStatic() && this.firstStaticClosure == null) {
                this.firstStaticClosure = node;
            }
            super.visit(node);
            if (this.firstStaticClosure == node) {
                this.firstStaticClosure = null;
            }
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.isInTypeDeclaration = true;
            super.visit(node);
            this.isInTypeDeclaration = false;
        }

        @Override
        public void visit(EnumDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.isInTypeDeclaration = true;
            super.visit(node);
            this.isInTypeDeclaration = false;
        }

        @Override
        public void visit(TraitDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.isInTypeDeclaration = true;
            super.visit(node);
            this.isInTypeDeclaration = false;
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            boolean hasFirstStaticClosure;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            boolean isInPreviousTypeDeclaration = this.isInTypeDeclaration;
            boolean bl = hasFirstStaticClosure = this.firstStaticClosure != null;
            if (node.isAnonymous()) {
                this.isInTypeDeclaration = true;
                this.isInStaticMethodStack.push(this.isInStaticMethod);
                this.isInStaticMethod = false;
                if (hasFirstStaticClosure) {
                    this.firstStaticClosureStack.push(this.firstStaticClosure);
                    this.firstStaticClosure = null;
                }
            }
            super.visit(node);
            if (node.isAnonymous()) {
                this.isInTypeDeclaration = isInPreviousTypeDeclaration;
                this.isInStaticMethod = this.isInStaticMethodStack.pop();
                if (hasFirstStaticClosure) {
                    this.firstStaticClosure = this.firstStaticClosureStack.pop();
                }
            }
        }

        @Override
        public void visit(Variable node) {
            String variableName;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.isInStaticContext() && "$this".equals(variableName = CodeUtils.extractVariableName(node))) {
                this.thisVariableInStaticContext.add(node);
            }
            super.visit(node);
        }

        private boolean isInStaticContext() {
            return this.isInStaticMethod || this.isInTypeDeclaration && this.firstStaticClosure != null;
        }

        public Set<Variable> getThisVariableInStaticContext() {
            return Collections.unmodifiableSet(this.thisVariableInStaticContext);
        }
    }
}

