/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;

public class ObjectReferenceBuilder
extends ObjectReferenceFluentImpl<ObjectReferenceBuilder>
implements VisitableBuilder<ObjectReference, ObjectReferenceBuilder> {
    ObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ObjectReferenceBuilder() {
        this(false);
    }

    public ObjectReferenceBuilder(Boolean validationEnabled) {
        this(new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance) {
        this(fluent, instance, false);
    }

    public ObjectReferenceBuilder(ObjectReferenceFluent<?> fluent, ObjectReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withFieldPath(instance.getFieldPath());
            fluent.withKind(instance.getKind());
            fluent.withName(instance.getName());
            fluent.withNamespace(instance.getNamespace());
            fluent.withResourceVersion(instance.getResourceVersion());
            fluent.withUid(instance.getUid());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ObjectReferenceBuilder(ObjectReference instance) {
        this(instance, (Boolean)false);
    }

    public ObjectReferenceBuilder(ObjectReference instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withFieldPath(instance.getFieldPath());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withResourceVersion(instance.getResourceVersion());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ObjectReference build() {
        ObjectReference buildable = new ObjectReference(this.fluent.getApiVersion(), this.fluent.getFieldPath(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getResourceVersion(), this.fluent.getUid());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

