/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.branch.Bundle;
import org.netbeans.modules.git.ui.branch.CreateBranchPanel;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class CreateBranch
implements DocumentListener {
    private final CreateBranchPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean revisionValid = false;
    private String msgInvalidName;
    private String branchName;
    private final Icon ICON_ERROR = ImageUtilities.loadIcon((String)"org/netbeans/modules/git/resources/icons/info.png");
    private final Map<String, GitBranch> existingBranches;
    private final Set<String> localBranchNames;
    private boolean internalChange;
    private boolean nameModifiedByUser;

    CreateBranch(File repository, String initialRevision, Map<String, GitBranch> existingBranches) {
        this.existingBranches = existingBranches;
        this.localBranchNames = CreateBranch.getLocalBranches(existingBranches);
        this.revisionPicker = new RevisionDialogController(repository, new File[]{repository}, initialRevision);
        this.panel = new CreateBranchPanel(this.revisionPicker.getPanel());
    }

    String getRevision() {
        return this.revisionPicker.getRevision().getRevision();
    }

    String getBranchName() {
        if (GitModuleConfig.getDefault().getAutoReplaceInvalidBranchNameCharacters()) {
            return GitUtils.normalizeBranchName(this.panel.branchNameField.getText());
        }
        return this.panel.branchNameField.getText().trim();
    }

    boolean isCheckoutSelected() {
        return this.panel.cbCheckoutBranch.isSelected();
    }

    boolean show() {
        this.okButton = new JButton(NbBundle.getMessage(CreateBranch.class, (String)"LBL_CreateBranch.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(CreateBranch.class, (String)"LBL_CreateBranch.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx("org.netbeans.modules.git.ui.branch.CreateBranch"), null);
        this.validate();
        this.revisionPicker.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName() == "RevisionDialogController.valid") {
                this.setRevisionValid(Boolean.TRUE.equals(evt.getNewValue()));
            }
        });
        this.panel.branchNameField.getDocument().addDocumentListener(this);
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        DialogBoundsPreserver.preserveAndRestore((Window)d, (Preferences)GitModuleConfig.getDefault().getPreferences(), (String)this.getClass().getName());
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    private void setRevisionValid(boolean flag) {
        this.revisionValid = flag;
        this.updateBranchName();
        if (!flag) {
            this.setErrorMessage(NbBundle.getMessage(CreateBranch.class, (String)"MSG_CreateBranch.errorRevision"));
        }
        this.validate();
    }

    private void validate() {
        boolean flag;
        boolean bl = flag = this.revisionValid && this.msgInvalidName == null;
        if (this.revisionValid && this.msgInvalidName != null) {
            this.setErrorMessage(this.msgInvalidName);
        }
        if (flag) {
            this.setErrorMessage(null);
        }
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateName();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateName();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void validateName() {
        if (!this.internalChange) {
            this.nameModifiedByUser = true;
        }
        this.msgInvalidName = null;
        this.branchName = this.getBranchName();
        if (this.branchName.isEmpty()) {
            this.msgInvalidName = Bundle.MSG_CreateBranch_errorBranchNameEmpty();
        } else if (!GitUtils.isValidBranchName(this.branchName)) {
            this.msgInvalidName = Bundle.MSG_CreateBranch_errorInvalidBranchName();
        } else if (this.localBranchNames.contains(this.branchName)) {
            this.msgInvalidName = Bundle.MSG_CreateBranch_errorBranchExists();
        } else {
            for (String branch : this.localBranchNames) {
                if (!this.branchName.startsWith(branch + "/") && !branch.startsWith(this.branchName + "/")) continue;
                this.msgInvalidName = Bundle.MSG_CreateBranch_errorParentExists(branch);
                break;
            }
        }
        this.validate();
    }

    private void setErrorMessage(String message) {
        this.panel.lblError.setText(message);
        if (message == null || message.isEmpty()) {
            this.panel.lblError.setIcon(null);
        } else {
            this.panel.lblError.setIcon(this.ICON_ERROR);
        }
    }

    private static Set<String> getLocalBranches(Map<String, GitBranch> existingBranches) {
        HashSet<String> branchNames = new HashSet<String>();
        for (Map.Entry<String, GitBranch> e : existingBranches.entrySet()) {
            GitBranch branch = e.getValue();
            if (branch.isRemote() || "(no branch)".equals(branch.getName())) continue;
            branchNames.add(e.getKey());
        }
        return branchNames;
    }

    private void updateBranchName() {
        if (!this.nameModifiedByUser) {
            this.internalChange = true;
            String revision = this.revisionPicker.getRevision().getRevision();
            if (revision.startsWith("refs/remotes/")) {
                revision = revision.substring("refs/remotes/".length());
            } else if (revision.startsWith("remotes/")) {
                revision = revision.substring(8);
            }
            for (Map.Entry<String, GitBranch> e : this.existingBranches.entrySet()) {
                if (!e.getValue().isRemote() || !e.getKey().equals(revision)) continue;
                String localBranch = revision.substring(revision.indexOf("/") + 1);
                this.panel.branchNameField.setText(localBranch);
            }
            this.internalChange = false;
        }
    }
}

