/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ListView;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class AntNavigatorPanel
implements NavigatorPanel {
    private Lookup.Result<DataObject> selection;
    private final LookupListener selectionListener = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (AntNavigatorPanel.this.selection != null) {
                        AntNavigatorPanel.this.display(AntNavigatorPanel.this.selection.allInstances());
                    }
                }
            });
        }
    };
    private JComponent panel;
    private final ExplorerManager manager = new ExplorerManager();
    private final Lookup lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)new ActionMap());

    public String getDisplayName() {
        return NbBundle.getMessage(AntNavigatorPanel.class, (String)"ANP_label");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(AntNavigatorPanel.class, (String)"ANP_hint");
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            final ListView view = new ListView();
            view.setSelectionMode(0);
            class Panel
            extends JPanel
            implements ExplorerManager.Provider,
            Lookup.Provider {
                final /* synthetic */ AntNavigatorPanel this$0;

                Panel() {
                    this.this$0 = this$0;
                    this.setLayout(new BorderLayout());
                    this.add((Component)view, "Center");
                }

                public ExplorerManager getExplorerManager() {
                    return this.this$0.manager;
                }

                @Override
                public boolean requestFocusInWindow() {
                    return view.requestFocusInWindow();
                }

                public Lookup getLookup() {
                    return this.this$0.lookup;
                }
            }
            this.panel = new Panel();
        }
        return this.panel;
    }

    public void panelActivated(Lookup context) {
        this.selection = context.lookupResult(DataObject.class);
        this.selection.addLookupListener(this.selectionListener);
        this.selectionListener.resultChanged(null);
    }

    public void panelDeactivated() {
        this.selection.removeLookupListener(this.selectionListener);
        this.selection = null;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void display(Collection<? extends DataObject> selectedFiles) {
        DataObject d;
        if (selectedFiles.size() == 1 && (d = selectedFiles.iterator().next()).isValid()) {
            this.manager.setRootContext(d.getNodeDelegate());
            return;
        }
        this.manager.setRootContext(Node.EMPTY);
    }
}

