/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.SubprojectsGroupEditPanel;
import org.netbeans.spi.project.ProjectContainerProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class SubprojectsGroup
extends Group {
    private static final Logger LOG = Logger.getLogger(SubprojectsGroup.class.getName());
    static final String KIND = "subprojects";

    public static SubprojectsGroup create(String name, Project project) {
        String path = project.getProjectDirectory().toURL().toExternalForm();
        String id = SubprojectsGroup.sanitizeNameAndUniquifyForId(name);
        LOG.log(Level.FINE, "Creating: {0}", id);
        Preferences p = NODE.node(id);
        p.put("name", name);
        p.put("kind", KIND);
        p.put("path", path);
        return new SubprojectsGroup(id);
    }

    SubprojectsGroup(String id) {
        super(id);
    }

    @Override
    protected String getNameOrNull() {
        Project p;
        String n = super.getNameOrNull();
        if (n == null && (p = SubprojectsGroup.projectForPath(this.prefs().get("path", null))) != null) {
            return ProjectUtils.getInformation((Project)p).getDisplayName();
        }
        return n;
    }

    @Override
    protected void findProjects(Set<Project> projects, ProgressHandle h, int start, int end) {
        assert (!SwingUtilities.isEventDispatchThread());
        Project p = SubprojectsGroup.projectForPath(this.prefs().get("path", null));
        if (p != null) {
            SubprojectsGroup.visitSubprojects(p, projects, true, h, new int[]{start, end});
        }
    }

    private static void visitSubprojects(Project p, Set<Project> projects, boolean main, ProgressHandle h, int[] startEnd) {
        if ((main || !ProjectConvertors.isConvertorProject((Project)p)) && projects.add(p)) {
            ProjectContainerProvider pcp;
            if (h != null) {
                startEnd[0] = startEnd[0] + 1;
                h.progress(SubprojectsGroup.progressMessage(p), Math.min(startEnd[0], startEnd[1]));
            }
            if ((pcp = (ProjectContainerProvider)p.getLookup().lookup(ProjectContainerProvider.class)) != null) {
                ProjectContainerProvider.Result res = pcp.getContainedProjects();
                projects.addAll(res.getProjects());
                if (!res.isRecursive()) {
                    SubprojectsGroup.visitSubprojects(p, projects, false, h, startEnd);
                }
            } else {
                SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
                if (spp != null) {
                    for (Project p2 : spp.getSubprojects()) {
                        SubprojectsGroup.visitSubprojects(p2, projects, false, h, startEnd);
                    }
                }
            }
        }
    }

    public FileObject getMasterProjectDirectory() {
        String p = this.prefs().get("path", null);
        if (p != null && p.length() > 0) {
            try {
                return URLMapper.findFileObject((URL)new URL(p));
            }
            catch (MalformedURLException x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        return null;
    }

    @Override
    public GroupEditPanel createPropertiesPanel() {
        return new SubprojectsGroupEditPanel(this);
    }
}

