/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.modules.search.project.AbstractProjectSearchScope;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class SearchScopeOpenProjects
extends AbstractProjectSearchScope {
    private static final String ALL_PROJECTS_ICON = "org/netbeans/modules/search/project/resources/all_projects.png";
    private static final Icon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/search/project/resources/all_projects.png", (boolean)false);

    SearchScopeOpenProjects() {
        super("openProjects");
    }

    public String getTypeId() {
        return "open projects";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"SearchScopeNameOpenProjects");
    }

    private boolean checkIsApplicable() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    public SearchInfo getSearchInfo() {
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        if (openProjects.length == 0) {
            return SearchInfoUtils.createEmptySearchInfo();
        }
        if (openProjects.length == 1) {
            return SearchScopeOpenProjects.createSingleProjectSearchInfo(openProjects[0]);
        }
        SearchInfo[] prjSearchInfos = new SearchInfo[openProjects.length];
        for (int i = 0; i < prjSearchInfos.length; ++i) {
            prjSearchInfos[i] = SearchScopeOpenProjects.createSingleProjectSearchInfo(openProjects[i]);
        }
        return SearchInfoUtils.createCompoundSearchInfo((SearchInfo[])prjSearchInfos);
    }

    public boolean isApplicable() {
        return this.checkIsApplicable();
    }

    public int getPriority() {
        return 200;
    }

    public Icon getIcon() {
        return ICON;
    }
}

