/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.util.Objects;
import org.netbeans.modules.docker.DockerUtils;
import org.netbeans.modules.docker.api.DockerEntityType;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerInstanceEntity;

public final class DockerContainer
implements DockerInstanceEntity {
    private final DockerInstance instance;
    private final String id;
    private final String image;
    private final String name;
    private Status status;

    @Override
    public DockerEntityType getType() {
        return DockerEntityType.Container;
    }

    DockerContainer(DockerInstance instance, String id, String image, String name, Status status) {
        this.instance = instance;
        this.id = id;
        this.image = image;
        this.name = name;
        this.status = status;
    }

    @Override
    public DockerInstance getInstance() {
        return this.instance;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getShortId() {
        return DockerUtils.getShortId(this);
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.instance);
        hash = 67 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerContainer other = (DockerContainer)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.instance, other.instance);
    }

    public String toString() {
        return "DockerContainer{instance=" + this.instance + ", id=" + this.id + ", image=" + this.image + '}';
    }

    public static enum Status {
        RUNNING,
        PAUSED,
        STOPPED;

    }
}

