/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.io.CharConversionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.openide.awt.HtmlRenderer;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public final class CustomizerComponentFactory {
    static DependencyListModel INVALID_DEP_LIST_MODEL;
    private static final String INVALID_PLATFORM;

    private CustomizerComponentFactory() {
    }

    static DependencyListModel createSortedDependencyListModel(Set<ModuleDependency> deps) {
        assert (deps != null);
        return new DependencyListModel(deps, true);
    }

    static DependencyListModel createDependencyListModel(Set<ModuleDependency> deps) {
        assert (deps != null);
        return new DependencyListModel(deps, false);
    }

    static synchronized DependencyListModel getInvalidDependencyListModel() {
        if (INVALID_DEP_LIST_MODEL == null) {
            INVALID_DEP_LIST_MODEL = new DependencyListModel(DependencyListModel.State.INVALID, true);
        }
        return INVALID_DEP_LIST_MODEL;
    }

    static ListCellRenderer getDependencyCellRenderer(boolean boldfaceApiModules) {
        return new DependencyListCellRenderer(boldfaceApiModules);
    }

    static ListCellRenderer getModuleCellRenderer() {
        return new ProjectListCellRenderer();
    }

    static ListCellRenderer getModuleEntryCellRenderer() {
        return new ModuleEntryListCellRenderer();
    }

    static {
        INVALID_PLATFORM = "<html><font color=\"!nb.errorForeground\">&lt;" + NbBundle.getMessage(CustomizerComponentFactory.class, (String)"MSG_InvalidPlatform") + "&gt;</font></html>";
    }

    static final class DependencyListModel
    extends AbstractListModel
    implements UIUtil.WaitingModel {
        private final Set<ModuleDependency> currentDeps;
        private boolean changed;
        private State state;

        DependencyListModel(Set<ModuleDependency> deps, boolean sorted) {
            if (sorted) {
                this.currentDeps = new TreeSet<ModuleDependency>(ModuleDependency.LOCALIZED_NAME_COMPARATOR);
                this.currentDeps.addAll(deps);
            } else {
                this.currentDeps = deps;
            }
            this.state = State.OK;
        }

        private DependencyListModel(State st, boolean sorted) {
            this.currentDeps = st == State.INVALID ? Collections.emptySet() : (sorted ? new TreeSet<ModuleDependency>(ModuleDependency.LOCALIZED_NAME_COMPARATOR) : new HashSet<ModuleDependency>());
            this.state = st;
        }

        @Override
        public int getSize() {
            return this.state != State.OK ? 1 : this.currentDeps.size();
        }

        @Override
        public Object getElementAt(int i) {
            switch (this.state.ordinal()) {
                case 2: {
                    Object[] currentDepsA = this.currentDeps.toArray();
                    return i >= 0 && i < currentDepsA.length ? currentDepsA[i] : INVALID_PLATFORM;
                }
                case 0: {
                    return INVALID_PLATFORM;
                }
            }
            return UIUtil.WAIT_VALUE;
        }

        public static DependencyListModel createBgWaitModel(boolean sorted) {
            return new DependencyListModel(State.WAITING, sorted);
        }

        void setDependencies(SortedSet<ModuleDependency> deps) {
            if (this.state != State.WAITING) {
                return;
            }
            this.currentDeps.addAll(deps);
            this.state = State.OK;
            int origSize = this.currentDeps.size();
            this.fireContentsChanged(this, 0, origSize);
        }

        void setInvalid() {
            if (this.state == State.INVALID) {
                throw new IllegalStateException("DependencyListModel already marked 'invalid'.");
            }
            this.state = State.INVALID;
            int origSize = this.currentDeps.size();
            this.fireContentsChanged(this, 0, origSize);
        }

        public boolean isWaiting() {
            return this.state == State.WAITING;
        }

        ModuleDependency getDependency(int i) {
            return (ModuleDependency)this.getElementAt(i);
        }

        void addDependency(ModuleDependency dep) {
            if (!this.currentDeps.contains(dep)) {
                int origSize = this.currentDeps.size();
                this.currentDeps.add(dep);
                this.changed = true;
                this.fireContentsChanged(this, 0, origSize);
            }
        }

        void removeDependencies(Collection<ModuleDependency> deps) {
            int origSize = this.currentDeps.size();
            this.currentDeps.removeAll(deps);
            this.changed = true;
            this.fireContentsChanged(this, 0, origSize);
        }

        void editDependency(ModuleDependency origDep, ModuleDependency newDep) {
            this.currentDeps.remove(origDep);
            this.currentDeps.add(newDep);
            this.changed = true;
            this.fireContentsChanged(this, 0, this.currentDeps.size());
        }

        Set<ModuleDependency> getDependencies() {
            return Collections.unmodifiableSet(this.currentDeps);
        }

        boolean isChanged() {
            return this.changed;
        }

        private static enum State {
            INVALID,
            WAITING,
            OK;

        }
    }

    private static final class DependencyListCellRenderer
    implements ListCellRenderer {
        private final HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();
        private final boolean boldfaceApiModules;

        public DependencyListCellRenderer(boolean boldfaceApiModules) {
            this.boldfaceApiModules = boldfaceApiModules;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object text;
            if (value == UIUtil.WAIT_VALUE) {
                text = UIUtil.WAIT_VALUE;
            } else if (value == INVALID_PLATFORM) {
                text = INVALID_PLATFORM;
                this.renderer.setHtml(true);
            } else {
                ModuleDependency md = (ModuleDependency)value;
                boolean bold = this.boldfaceApiModules && md.getModuleEntry().getPublicPackages().length > 0;
                boolean deprecated = md.getModuleEntry().isDeprecated();
                this.renderer.setHtml(bold || deprecated);
                String locName = md.getModuleEntry().getLocalizedName();
                text = locName;
                if (bold || deprecated) {
                    try {
                        text = "<html>" + (bold ? "<b>" : "") + (deprecated ? "<s>" : "") + XMLUtil.toElementContent((String)locName);
                    }
                    catch (CharConversionException charConversionException) {
                        // empty catch block
                    }
                }
            }
            return this.renderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }

    private static class ProjectListCellRenderer
    extends DefaultListCellRenderer {
        private ProjectListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, ProjectUtils.getInformation((Project)((Project)value)).getDisplayName(), index, isSelected, cellHasFocus);
            return c;
        }
    }

    private static class ModuleEntryListCellRenderer
    extends DefaultListCellRenderer {
        private ModuleEntryListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ModuleEntry me = (ModuleEntry)value;
            Component c = super.getListCellRendererComponent((JList<?>)list, me.getLocalizedName(), index, isSelected, cellHasFocus);
            return c;
        }
    }

    static final class SuiteSubModulesListModel
    extends AbstractListModel {
        private final SortedSet<NbModuleProject> subModules = new TreeSet<NbModuleProject>(Util.projectDisplayNameComparator());
        private boolean changed;

        SuiteSubModulesListModel(Set<NbModuleProject> subModules) {
            this.subModules.addAll(subModules);
        }

        @Override
        public int getSize() {
            return this.subModules.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.subModules.toArray()[i];
        }

        boolean contains(Project module) {
            return this.subModules.contains(module);
        }

        void removeModules(Collection modules) {
            int origSize = this.subModules.size();
            this.subModules.removeAll(modules);
            this.changed = true;
            this.fireContentsChanged(this, 0, origSize);
        }

        boolean addModule(NbModuleProject module) {
            int origSize = this.subModules.size();
            boolean added = this.subModules.add(module);
            this.changed = true;
            this.fireContentsChanged(this, 0, origSize + 1);
            return added;
        }

        public Set<NbModuleProject> getSubModules() {
            return Collections.unmodifiableSortedSet(this.subModules);
        }

        public boolean isChanged() {
            return this.changed;
        }
    }

    static final class RequiredTokenListModel
    extends AbstractListModel {
        private final SortedSet<String> tokens;
        private boolean changed;

        RequiredTokenListModel(SortedSet<String> tokens) {
            this.tokens = new TreeSet<String>(tokens);
        }

        @Override
        public Object getElementAt(int index) {
            return index >= this.tokens.size() ? null : this.tokens.toArray()[index];
        }

        @Override
        public int getSize() {
            return this.tokens.size();
        }

        void addToken(String token) {
            this.tokens.add(token);
            this.changed = true;
            super.fireIntervalAdded(this, 0, this.tokens.size());
        }

        void removeToken(String token) {
            this.tokens.remove(token);
            this.changed = true;
            super.fireIntervalRemoved(this, 0, this.tokens.size());
        }

        String[] getTokens() {
            String[] result = new String[this.tokens.size()];
            return this.tokens.toArray(result);
        }

        boolean isChanged() {
            return this.changed;
        }
    }

    static final class FriendListModel
    extends AbstractListModel {
        private final Set<String> friends = new TreeSet<String>();
        private boolean changed;

        FriendListModel(String[] friends) {
            if (friends != null) {
                this.friends.addAll(Arrays.asList(friends));
            }
        }

        @Override
        public Object getElementAt(int index) {
            if (index >= this.friends.size()) {
                return null;
            }
            return this.friends.toArray()[index];
        }

        @Override
        public int getSize() {
            return this.friends.size();
        }

        void addFriend(String friend) {
            this.friends.add(friend);
            this.changed = true;
            super.fireIntervalAdded(this, 0, this.friends.size());
        }

        void removeFriend(String friend) {
            this.friends.remove(friend);
            this.changed = true;
            super.fireIntervalRemoved(this, 0, this.friends.size());
        }

        Set<String> getFriends() {
            return Collections.unmodifiableSet(this.friends);
        }

        boolean isChanged() {
            return this.changed;
        }
    }

    static final class PublicPackagesTableModel
    extends AbstractTableModel {
        private Boolean[] selected;
        private Boolean[] originalSelected;
        private String[] pkgNames;

        PublicPackagesTableModel(Map<String, Boolean> publicPackages) {
            this.reloadData(publicPackages);
        }

        void reloadData(Map<String, Boolean> publicPackages) {
            this.selected = new Boolean[publicPackages.size()];
            publicPackages.values().toArray(this.selected);
            if (this.originalSelected == null) {
                this.originalSelected = new Boolean[publicPackages.size()];
                System.arraycopy(this.selected, 0, this.originalSelected, 0, this.selected.length);
            }
            this.pkgNames = new String[publicPackages.size()];
            publicPackages.keySet().toArray(this.pkgNames);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.pkgNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.selected[rowIndex];
            }
            return this.pkgNames[rowIndex];
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0) : "Who is trying to modify second column?";
            this.selected[rowIndex] = (Boolean)aValue;
            this.fireTableCellUpdated(rowIndex, 0);
        }

        Set<String> getSelectedPackages() {
            TreeSet<String> s = new TreeSet<String>();
            for (int i = 0; i < this.pkgNames.length; ++i) {
                if (!this.selected[i].booleanValue()) continue;
                s.add(this.pkgNames[i]);
            }
            return s;
        }

        public boolean isChanged() {
            return !Arrays.asList(this.selected).equals(Arrays.asList(this.originalSelected));
        }
    }
}

