/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaParameter;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.TypeUtil;

public class ReflectionHelper {
    public static TypeNodeData createTypeData(String typeName, Object value) {
        return ReflectionHelper.createTypeData(typeName, null, value);
    }

    public static TypeNodeData createTypeData(String typeName, String paramName) {
        return ReflectionHelper.createTypeData(typeName, paramName, null);
    }

    public static TypeNodeData createTypeData(String typeName, String paramName, Object value) {
        int separator = ReflectionHelper.separateGenericType(typeName);
        String typeClass = typeName.substring(0, separator);
        String genericType = null;
        if (separator != typeName.length()) {
            genericType = typeName.substring(separator + 1, typeName.length() - 1);
        }
        TypeNodeData result = new TypeNodeData(typeClass, genericType, paramName, value);
        if (ReflectionHelper.isArray(typeClass)) {
            result.setGenericType(typeClass.substring(0, typeClass.indexOf("[]")));
        }
        return result;
    }

    private static int separateGenericType(String typeName) {
        int length = typeName.length();
        if (length < 2 || typeName.charAt(length - 1) != '>') {
            return length;
        }
        int depth = 1;
        for (int i = length - 2; i >= 0; --i) {
            if (typeName.charAt(i) == '>') {
                ++depth;
            } else if (typeName.charAt(i) == '<') {
                --depth;
            }
            if (depth != 0) continue;
            return i;
        }
        return length;
    }

    public static boolean isArray(String className) {
        return className != null && className.contains("[]");
    }

    public static boolean isComplexType(String className, ClassLoader runtimeClassLoader) {
        try {
            Class<?> type = Class.forName(className, true, runtimeClassLoader);
            Class<?> xmlType = Class.forName(XmlType.class.getName(), true, runtimeClassLoader);
            Object xmlAnnotation = type.getAnnotation(xmlType);
            boolean isEnumeration = ReflectionHelper.isEnumeration(className, runtimeClassLoader);
            return xmlAnnotation != null && !isEnumeration;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static boolean isCollection(String className, ClassLoader runtimeClassLoader) {
        try {
            Class<?> cls = Class.forName(className, true, runtimeClassLoader);
            return Collection.class.isAssignableFrom(cls);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static boolean isHolder(String className) {
        return "javax.xml.ws.Holder".equals(className);
    }

    public static boolean isJAXBElement(String className) {
        return "javax.xml.bind.JAXBElement".equals(className);
    }

    public static boolean isEnumeration(String className, ClassLoader loader) {
        try {
            Class<?> cls = Class.forName(className, true, loader);
            Class<?> enumClass = Class.forName(Enum.class.getName(), true, loader);
            return enumClass.isAssignableFrom(cls);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static boolean isSimpleType(String className, ClassLoader loader) {
        try {
            if (ReflectionHelper.isPrimitiveClass(className)) {
                return true;
            }
            Class.forName(className, true, loader);
            return !ReflectionHelper.isCollection(className, loader) && !ReflectionHelper.isHolder(className) && !ReflectionHelper.isComplexType(className, loader) && !ReflectionHelper.isEnumeration(className, loader) && !ReflectionHelper.isJAXBElement(className);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static Object makeGenericArray(String componentType, int length, ClassLoader loader) throws WebServiceReflectionException {
        try {
            Class<?> componentClass = ReflectionHelper.isPrimitiveClass(componentType) ? ReflectionHelper.getPrimitiveClass(componentType) : Class.forName(componentType, true, loader);
            return Array.newInstance(componentClass, length);
        }
        catch (ReflectiveOperationException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static Object makeJAXBElement(String valueType, String localPart, Object value, ClassLoader loader) throws WebServiceReflectionException {
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (valueType == null || loader == null) {
                Object var5_5 = null;
                return var5_5;
            }
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> declaredClass = ReflectionHelper.isPrimitiveClass(valueType) ? ReflectionHelper.getPrimitiveClass(valueType) : Class.forName(valueType, true, loader);
            Class<?> qNameClass = Class.forName(QName.class.getName(), true, loader);
            Class<?> jaxBClass = Class.forName(JAXBElement.class.getName(), true, loader);
            Constructor<?> qNameConstr = qNameClass.getConstructor(String.class);
            Object qName = qNameConstr.newInstance(localPart);
            Constructor<?> jaxBConstr = jaxBClass.getConstructor(qNameClass, Class.class, Object.class);
            Object obj = jaxBConstr.newInstance(qName, declaredClass, value);
            return obj;
        }
        catch (ReflectiveOperationException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
        finally {
            if (savedLoader != null) {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
    }

    public static Object makeEnumeration(String enumeration, ClassLoader loader) throws WebServiceReflectionException {
        try {
            List<String> enumerationValues = ReflectionHelper.getEnumerationValues(enumeration, loader);
            Class<?> enumClass = Class.forName(enumeration, true, loader);
            return Enum.valueOf(enumClass, enumerationValues.get(0));
        }
        catch (ReflectiveOperationException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static Object getEnumeration(String enumeration, String name, ClassLoader loader) throws WebServiceReflectionException {
        try {
            Class<?> enumClass = Class.forName(enumeration, true, loader);
            return Enum.valueOf(enumClass, name);
        }
        catch (ReflectiveOperationException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static Object makeHolder(ClassLoader loader) throws WebServiceReflectionException {
        return ReflectionHelper.makeComplexType("javax.xml.ws.Holder", loader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object makeCollection(String className, ClassLoader loader) throws WebServiceReflectionException {
        Object obj;
        ClassLoader savedLoader;
        block11: {
            ArrayList arrayList;
            block10: {
                savedLoader = null;
                try {
                    Object result;
                    if (!ReflectionHelper.isCollection(className, loader)) {
                        Object var3_3 = null;
                        return var3_3;
                    }
                    Class<?> cls = Class.forName(className, true, loader);
                    if (cls.isInterface()) {
                        arrayList = new ArrayList();
                        if (savedLoader == null) return arrayList;
                        break block10;
                    }
                    savedLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(loader);
                    obj = result = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (savedLoader == null) return obj;
                    break block11;
                }
                catch (ReflectiveOperationException | SecurityException ex) {
                    throw new WebServiceReflectionException(ex.getClass().getName(), ex);
                }
            }
            Thread.currentThread().setContextClassLoader(savedLoader);
            return arrayList;
        }
        Thread.currentThread().setContextClassLoader(savedLoader);
        return obj;
        finally {
            if (savedLoader != null) {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
    }

    public static Object makeComplexType(String typeName, ClassLoader loader) throws WebServiceReflectionException {
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object result;
            if (typeName == null || loader == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> typeClass = Class.forName(typeName, true, loader);
            Object obj = result = typeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (ReflectiveOperationException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
        finally {
            if (savedLoader != null) {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
    }

    public static List<String> getEnumerationValues(String enumeration, ClassLoader loader) throws WebServiceReflectionException {
        try {
            ArrayList<String> enumerations = new ArrayList<String>();
            Class<?> enumerClass = Class.forName(enumeration, true, loader);
            Field[] fields = enumerClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field nextField = fields[i];
                if (!nextField.isEnumConstant()) continue;
                enumerations.add(nextField.getName());
            }
            return enumerations;
        }
        catch (ClassNotFoundException | SecurityException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static List<String> getPropertyNames(String complexType, ClassLoader loader) throws WebServiceReflectionException {
        ClassLoader savedLoader = null;
        try {
            Object annotation;
            ArrayList<String> properties = new ArrayList<String>();
            savedLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> xmlTypeClass = Class.forName(XmlType.class.getName(), true, loader);
            for (Class<?> nextClass = Class.forName(complexType, true, loader); nextClass != null && (annotation = nextClass.getAnnotation(xmlTypeClass)) != null; nextClass = nextClass.getSuperclass()) {
                try {
                    Method m = annotation.getClass().getMethod("propOrder", new Class[0]);
                    String[] props = (String[])m.invoke(annotation, null);
                    for (int i = 0; props != null && i < props.length; ++i) {
                        if (props[i] == null || props[i].length() <= 0) continue;
                        properties.add(props[i]);
                    }
                    continue;
                }
                catch (ReflectiveOperationException | SecurityException exception) {
                    // empty catch block
                }
            }
            ArrayList<String> arrayList = properties;
            return arrayList;
        }
        catch (ClassNotFoundException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
        finally {
            if (savedLoader != null) {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
    }

    public static String getPropertyType(String type, String propName, ClassLoader loader) throws WebServiceReflectionException {
        ClassLoader savedLoader = null;
        try {
            Class<?> typeClass = Class.forName(type, true, loader);
            char[] name = propName.toCharArray();
            Method method = null;
            for (int i = 0; i < propName.length() && method == null; ++i) {
                name[i] = Character.toUpperCase(name[i]);
                String propCaps = new String(name);
                try {
                    method = typeClass.getMethod("get" + propCaps, new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    try {
                        method = typeClass.getMethod("is" + propCaps, new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (method == null) {
                throw new NoSuchMethodException("Method not found for property " + propName + " in class " + type);
            }
            String string = TypeUtil.typeToString((Type)method.getGenericReturnType());
            return string;
        }
        catch (ReflectiveOperationException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
        finally {
            if (savedLoader != null) {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
    }

    public static Object getHolderValue(Object holder) throws WebServiceReflectionException {
        try {
            Field valueField = holder.getClass().getField("value");
            return valueField.get(holder);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static void setHolderValue(Object holder, Object value) throws WebServiceReflectionException {
        try {
            Field valueField = holder.getClass().getField("value");
            valueField.set(holder, value);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static Object getJAXBElementValue(Object jaxBElement) throws WebServiceReflectionException {
        try {
            Method m = jaxBElement.getClass().getMethod("getValue", new Class[0]);
            return m.invoke(jaxBElement, new Object[0]);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static String getQNameLocalPart(Object jaxBElement) throws WebServiceReflectionException {
        try {
            Method getName = jaxBElement.getClass().getMethod("getName", new Class[0]);
            Object qName = getName.invoke(jaxBElement, new Object[0]);
            Method getLocalPart = qName.getClass().getMethod("getLocalPart", new Class[0]);
            return (String)getLocalPart.invoke(qName, new Object[0]);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static void setJAXBElementValue(Object jaxBElement, Object value) throws WebServiceReflectionException {
        try {
            Method m = jaxBElement.getClass().getMethod("setValue", Object.class);
            m.invoke(jaxBElement, value);
        }
        catch (ReflectiveOperationException | SecurityException ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPropertySettable(String className, String propName, ClassLoader classLoader) throws WebServiceReflectionException {
        block10: {
            block8: {
                block9: {
                    savedLoader = null;
                    try {
                        name = propName.toCharArray();
                        name[0] = Character.toUpperCase(name[0]);
                        capitalProp = new String(name);
                        writeMethod = "set" + capitalProp;
                        savedLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(classLoader);
                        structClass = Class.forName(className, true, classLoader);
                        methods = structClass.getMethods();
                        i = 0;
lbl12:
                        // 2 sources

                        while (i < methods.length) {
                            curMethod = methods[i];
                            if (curMethod.getName().equals(writeMethod) && curMethod.getParameterTypes().length == 1) {
                                var11_12 = true;
                                if (savedLoader == null) break block8;
                                break block9;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl33
                    }
                    catch (ClassNotFoundException | SecurityException ex) {
                        try {
                            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
                        }
                        catch (Throwable var12_13) {
                            if (savedLoader != null) {
                                Thread.currentThread().setContextClassLoader(savedLoader);
                            }
                            throw var12_13;
                        }
                    }
                }
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
            return var11_12;
lbl-1000:
            // 1 sources

            {
                ++i;
                ** GOTO lbl12
lbl33:
                // 1 sources

                var9_10 = false;
                if (savedLoader == null) break block10;
            }
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
        return var9_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyValue(Object objValue, String propName, String propType, Object propValue, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader savedLoader = null;
        try {
            Class<?> typeClass = objValue.getClass();
            savedLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Class<?> propClass = ReflectionHelper.isPrimitiveClass(propType) ? ReflectionHelper.referenceClass2PrimitiveClass(propValue.getClass()) : Class.forName(propType, true, classLoader);
                Class[] params = new Class[]{propClass};
                char[] name = propName.toCharArray();
                Method method = null;
                for (int i = 0; i < propName.length() && method == null; ++i) {
                    name[i] = Character.toUpperCase(name[i]);
                    String methodName = "set" + new String(name);
                    try {
                        method = typeClass.getMethod(methodName, params);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (method == null) {
                    throw new NoSuchMethodException("Method setter for property " + propName + " not found in class " + typeClass);
                }
                Object[] args = new Object[]{propValue};
                method.invoke(objValue, args);
            }
            catch (ReflectiveOperationException ex) {
                throw new WebServiceReflectionException(ex.getClass().getName(), ex);
            }
        }
        finally {
            if (savedLoader != null) {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
    }

    public static Object getPropertyValue(Object obj, String propertyName, ClassLoader classLoader) throws WebServiceReflectionException {
        ClassLoader savedLoader = null;
        Class<?> typeClass = obj.getClass();
        Method method = null;
        savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        char[] name = propertyName.toCharArray();
        for (int i = 0; i < propertyName.length() && method == null; ++i) {
            name[i] = Character.toUpperCase(name[i]);
            String propCaps = new String(name);
            try {
                method = typeClass.getMethod("get" + propCaps, new Class[0]);
                continue;
            }
            catch (NoSuchMethodException ex) {
                try {
                    method = typeClass.getMethod("is" + propCaps, new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        try {
            if (method == null) {
                throw new NoSuchMethodException("Method not found for property " + propertyName + " in class " + typeClass);
            }
            Object i = method.invoke(obj, new Object[0]);
            if (savedLoader != null) {
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
            return i;
        }
        catch (ReflectiveOperationException ex) {
            try {
                throw new WebServiceReflectionException(ex.getClass().getName(), ex);
            }
            catch (Throwable throwable) {
                if (savedLoader != null) {
                    Thread.currentThread().setContextClassLoader(savedLoader);
                }
                throw throwable;
            }
        }
    }

    public static Object getArrayValue(Object array, int index) throws WebServiceReflectionException {
        try {
            return Array.get(array, index);
        }
        catch (Exception ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    public static int getArrayLength(Object array) throws WebServiceReflectionException {
        try {
            return Array.getLength(array);
        }
        catch (Exception ex) {
            throw new WebServiceReflectionException(ex.getClass().getName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callMethodWithParams(String inClassName, LinkedList inParamList, JavaMethod inMethod, URLClassLoader urlClassLoader, WsdlData wsData, WSPort port) throws WebServiceReflectionException {
        Class<?> clazz = null;
        Class<?> serviceClass = null;
        if (null == urlClassLoader) {
            return null;
        }
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            try {
                serviceClass = Class.forName(inClassName, true, urlClassLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new WebServiceReflectionException("ClassNotFoundException", cnfe);
            }
            Object classInstance = null;
            try {
                Object serviceObject;
                int start;
                File wsdlFile = new File(wsData.getWsdlFile()).getCanonicalFile();
                boolean isRPCEncoded = JaxWsUtils.isRPCEncoded((URI)wsdlFile.toURI());
                URL wsdlUrl = isRPCEncoded ? wsData.getJaxRpcDescriptor().getWsdlUrl() : wsData.getJaxWsDescriptor().getWsdlUrl();
                String urlPath = wsdlUrl.getPath();
                start = wsdlUrl.getProtocol().toLowerCase().startsWith("file") ? ((start = urlPath.lastIndexOf(System.getProperty("path.separator"))) < 0 ? urlPath.lastIndexOf("/") : start) : urlPath.lastIndexOf("/");
                start = start < 0 || start >= urlPath.length() - 1 ? 0 : start + 1;
                String wsdlFileName = urlPath.substring(start);
                String namespace = isRPCEncoded ? wsData.getJaxRpcDescriptor().getModel().getNamespaceURI() : wsData.getJaxWsDescriptor().getModel().getNamespaceURI();
                String qname = isRPCEncoded ? wsData.getJaxRpcDescriptor().getName() : wsData.getJaxWsDescriptor().getName();
                URL jarWsdlUrl = serviceClass.getResource(wsdlFileName);
                QName name = new QName(namespace, qname);
                if (isRPCEncoded) {
                    serviceObject = serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    Constructor<?> constructor = serviceClass.getConstructor(URL.class, QName.class);
                    serviceObject = constructor.newInstance(jarWsdlUrl, name);
                }
                String portGetter = port.getPortGetter();
                Method getPort = serviceObject.getClass().getMethod(portGetter, new Class[0]);
                classInstance = getPort.invoke(serviceObject, new Object[0]);
                clazz = classInstance.getClass();
            }
            catch (IOException | ReflectiveOperationException ex) {
                throw new WebServiceReflectionException(ex.getClass().getName(), ex);
            }
            Method method = null;
            Object[] paramValues = inParamList.toArray();
            LinkedList<Class<Calendar>> classList = new LinkedList<Class<Calendar>>();
            List parameterList = inMethod.getParametersList();
            for (int ii = 0; null != paramValues && ii < paramValues.length; ++ii) {
                Class classToAdd = null;
                if (null != parameterList && ii < parameterList.size()) {
                    JavaParameter actualParameter = (JavaParameter)parameterList.get(ii);
                    String formalName = actualParameter.getType().getFormalName();
                    if (ReflectionHelper.isPrimitiveClass(formalName)) {
                        classToAdd = ReflectionHelper.referenceClass2PrimitiveClass(paramValues[ii].getClass());
                    } else if (formalName.equals("java.util.Calendar") && !actualParameter.isHolder()) {
                        classToAdd = Calendar.class;
                    } else if (formalName.equals("java.util.List") || formalName.startsWith("java.util.List<") && !actualParameter.isHolder()) {
                        classToAdd = List.class;
                    } else if (paramValues[ii] == null) {
                        try {
                            classToAdd = Class.forName(formalName, true, urlClassLoader);
                        }
                        catch (Exception ex) {
                            throw new WebServiceReflectionException("Exception", ex);
                        }
                    } else {
                        classToAdd = paramValues[ii].getClass();
                    }
                }
                classList.add(classToAdd);
            }
            Class[] paramClasses = classList.toArray(new Class[0]);
            try {
                method = clazz.getMethod(inMethod.getName(), paramClasses);
            }
            catch (NoSuchMethodException nsme) {
                throw new WebServiceReflectionException("NoSuchMethodException", nsme);
            }
            Object returnObject = null;
            try {
                returnObject = method.invoke(classInstance, paramValues);
            }
            catch (ReflectiveOperationException ex) {
                throw new WebServiceReflectionException(ex.getClass().getName(), ex);
            }
            Object object = returnObject;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
    }

    public static boolean isPrimitiveClass(String inType) {
        return inType.equalsIgnoreCase("int") || inType.equalsIgnoreCase("byte") || inType.equalsIgnoreCase("boolean") || inType.equalsIgnoreCase("float") || inType.equalsIgnoreCase("double") || inType.equalsIgnoreCase("long") || inType.equalsIgnoreCase("short");
    }

    public static Class getPrimitiveClass(String inType) {
        if (inType.equalsIgnoreCase("int")) {
            return Integer.TYPE;
        }
        if (inType.equalsIgnoreCase("byte")) {
            return Byte.TYPE;
        }
        if (inType.equalsIgnoreCase("boolean")) {
            return Boolean.TYPE;
        }
        if (inType.equalsIgnoreCase("float")) {
            return Float.TYPE;
        }
        if (inType.equalsIgnoreCase("double")) {
            return Double.TYPE;
        }
        if (inType.equalsIgnoreCase("long")) {
            return Long.TYPE;
        }
        if (inType.equalsIgnoreCase("short")) {
            return Short.TYPE;
        }
        return null;
    }

    public static Class referenceClass2PrimitiveClass(Class inClass) {
        if (null == inClass) {
            return inClass;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Double")) {
            return Double.TYPE;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Float")) {
            return Float.TYPE;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Long")) {
            return Long.TYPE;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Short")) {
            return Short.TYPE;
        }
        if (inClass.getName().equalsIgnoreCase("java.lang.Character")) {
            return Character.TYPE;
        }
        return inClass;
    }
}

