/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class LazyComboBox<E>
extends JComboBox<E> {
    public LazyComboBox(Populator<E> populator) {
        super(new LazyComboBoxModel<E>(populator));
        this.setPrototypeDisplayValue(populator.initial());
    }

    @Override
    public final void setModel(ComboBoxModel<E> model) {
        if (!(model instanceof LazyComboBoxModel)) {
            throw new IllegalArgumentException("Can only use private LazyComboBoxModel");
        }
        super.setModel(model);
    }

    private LazyComboBoxModel<E> _getModel() {
        return (LazyComboBoxModel)super.getModel();
    }

    @Override
    public final int getSelectedIndex() {
        return this._getModel().isPopulated() ? super.getSelectedIndex() : -1;
    }

    @Override
    public final void setSelectedItem(Object newSelected) {
        LazyComboBoxModel<E> m = this._getModel();
        E oldSelected = m.getSelectedItem();
        m.setSelectedItem(newSelected);
        if (!Objects.equals(oldSelected, newSelected)) {
            this.repaint();
            this.selectionChanged();
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent e) {
        super.fireItemStateChanged(e);
        if (e.getStateChange() == 1) {
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
    }

    public final void resetModel() {
        LazyComboBoxModel<E> m = this._getModel();
        E oldSelected = m.getSelectedItem();
        m.reset(true);
        if (!Objects.equals(oldSelected, m.getSelectedItem())) {
            this.repaint();
            this.selectionChanged();
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension d = this.getPrototypeDisplayValue() != null || this._getModel().isPopulated() ? super.getPreferredSize() : new JComboBox<Object>(new Object[]{this._getModel().getSelectedItem()}).getPreferredSize();
        if (this.getPreferredWidth() >= 0) {
            d.width = Math.max(d.width, this.getPreferredWidth());
        }
        return d;
    }

    @Override
    public final Dimension getMinimumSize() {
        Dimension d = this.getPreferredSize();
        d.width = this.getPreferredWidth() < 0 ? 0 : Math.max(0, this.getPreferredWidth());
        return d;
    }

    @Override
    public final Dimension getMaximumSize() {
        Dimension d = this.getPreferredSize();
        d.width = this.getPreferredWidth() < 0 ? Integer.MAX_VALUE : Math.max(d.width, this.getPreferredWidth());
        return d;
    }

    protected int getPreferredWidth() {
        return -1;
    }

    private static class LazyComboBoxModel<E>
    extends AbstractListModel<E>
    implements ComboBoxModel<E> {
        private E[] items;
        private E selected;
        private final Populator<E> populator;

        LazyComboBoxModel(Populator<E> populator) {
            this.populator = populator;
            this.selected = populator.initial();
        }

        @Override
        public void setSelectedItem(Object selected) {
            this.selected = selected;
        }

        @Override
        public E getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.getItems().length;
        }

        @Override
        public E getElementAt(int index) {
            return this.getItems()[index];
        }

        boolean isPopulated() {
            return this.items != null;
        }

        private E[] getItems() {
            if (this.items == null) {
                this.items = this.populator.populate();
                if (this.items == null) {
                    throw new UnsupportedOperationException("Populator returned null");
                }
                this.fireContentsChanged(this, -1, -1);
            }
            return this.items;
        }

        void reset(boolean selection) {
            this.items = null;
            if (selection && !Objects.equals(this.selected, this.populator.initial()) && !this.containsItem(this.selected)) {
                this.selected = this.populator.initial();
            }
        }

        private boolean containsItem(E item) {
            for (E e : this.populator.populate()) {
                if (!Objects.equals(e, item)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class Populator<E> {
        protected abstract E initial();

        protected abstract E[] populate();
    }
}

