/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.util.Properties;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public abstract class TimedGlobalProfilingPoint
extends GlobalProfilingPoint {
    static final String PROPERTY_TIME = "p_timecond";
    private TimeCondition condition = new TimeCondition();

    TimedGlobalProfilingPoint(String name, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, project, factory);
    }

    public void setCondition(TimeCondition condition) {
        if (this.condition.equals(condition)) {
            return;
        }
        TimeCondition oldCondition = this.condition;
        this.condition = condition;
        this.getChangeSupport().firePropertyChange(PROPERTY_TIME, oldCondition, condition);
    }

    public TimeCondition getCondition() {
        return this.condition;
    }

    public static class TimeCondition {
        public static final String PROPERTY_TIMECOND_STARTTIME = "p_timecond_starttime";
        public static final String PROPERTY_TIMECOND_REPEATS = "p_timecond_repeats";
        public static final String PROPERTY_TIMECOND_PERIODTIME = "p_timecond_periodtime";
        public static final String PROPERTY_TIMECOND_PERIODUNITS = "p_timecond_periodunits";
        public static final int UNITS_MINUTES = 1;
        public static final int UNITS_HOURS = 2;
        private boolean repeats;
        private int periodTime;
        private int periodUnits;
        private long scheduledTime;
        private long startTime;

        public TimeCondition() {
            this(System.currentTimeMillis());
        }

        public TimeCondition(long startTime) {
            this(startTime, false, 1, 1);
        }

        public TimeCondition(long startTime, boolean repeats, int periodTime, int periodUnits) {
            this.setStartTime(startTime);
            this.setRepeats(repeats);
            this.setPeriodTime(periodTime);
            this.setPeriodUnits(periodUnits);
            this.setScheduledTime(startTime);
        }

        public void setPeriodTime(int periodTime) {
            this.periodTime = periodTime;
        }

        public int getPeriodTime() {
            return this.periodTime;
        }

        public void setPeriodUnits(int periodUnits) {
            this.periodUnits = periodUnits;
        }

        public int getPeriodUnits() {
            return this.periodUnits;
        }

        public void setRepeats(boolean repeats) {
            this.repeats = repeats;
        }

        public boolean getRepeats() {
            return this.repeats;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
            this.scheduledTime = startTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TimeCondition)) {
                return false;
            }
            TimeCondition condition = (TimeCondition)object;
            return this.startTime == condition.startTime && this.repeats == condition.repeats && this.periodTime == condition.periodTime && this.periodUnits == condition.periodUnits;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (this.repeats ? 1 : 0);
            hash = 53 * hash + this.periodTime;
            hash = 53 * hash + this.periodUnits;
            hash = 53 * hash + (int)(this.startTime ^ this.startTime >>> 32);
            return hash;
        }

        public static TimeCondition load(Lookup.Provider project, int index, Properties properties) {
            return TimeCondition.load(project, index, null, properties);
        }

        public static TimeCondition load(Lookup.Provider project, int index, String prefix, Properties properties) {
            String absPrefix = prefix == null ? index + "_" : index + "_" + prefix;
            String startTimeStr = properties.getProperty(absPrefix + PROPERTY_TIMECOND_STARTTIME, null);
            String repeatsStr = properties.getProperty(absPrefix + PROPERTY_TIMECOND_REPEATS, null);
            String periodTimeStr = properties.getProperty(absPrefix + PROPERTY_TIMECOND_PERIODTIME, null);
            String periodUnitsStr = properties.getProperty(absPrefix + PROPERTY_TIMECOND_PERIODUNITS, null);
            if (startTimeStr == null || repeatsStr == null || periodTimeStr == null || periodUnitsStr == null) {
                return null;
            }
            TimeCondition condition = null;
            try {
                condition = new TimeCondition(Long.parseLong(startTimeStr), Boolean.parseBoolean(repeatsStr), Integer.parseInt(periodTimeStr), Integer.parseInt(periodUnitsStr));
            }
            catch (Exception e) {
                ErrorManager.getDefault().log(65536, e.getMessage());
            }
            return condition;
        }

        public void store(Lookup.Provider project, int index, Properties properties) {
            this.store(project, index, null, properties);
        }

        public void store(Lookup.Provider project, int index, String prefix, Properties properties) {
            String absPrefix = prefix == null ? index + "_" : index + "_" + prefix;
            properties.put(absPrefix + PROPERTY_TIMECOND_STARTTIME, Long.toString(this.startTime));
            properties.put(absPrefix + PROPERTY_TIMECOND_REPEATS, Boolean.toString(this.repeats));
            properties.put(absPrefix + PROPERTY_TIMECOND_PERIODTIME, Integer.toString(this.periodTime));
            properties.put(absPrefix + PROPERTY_TIMECOND_PERIODUNITS, Integer.toString(this.periodUnits));
        }

        void setScheduledTime(long scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        long getScheduledTime() {
            return this.scheduledTime;
        }
    }
}

