/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.xml.schema.completion.CompletionPaintComponent;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.openide.util.NbBundle;

public class EndTagResultItem
extends CompletionResultItem {
    private static final Logger _logger = Logger.getLogger(EndTagResultItem.class.getName());
    private int endTagSortPriority = -1;

    public EndTagResultItem(String tagName, TokenSequence tokenSequence) {
        super(null, null);
        this.itemText = tagName;
        this.setTokenSequence(tokenSequence);
    }

    @Override
    public String getDisplayText() {
        return "</" + (this.itemText != null ? this.itemText : NbBundle.getMessage(EndTagResultItem.class, (String)"UNKNOWN_TAG_NAME")) + ">";
    }

    @Override
    public String getReplacementText() {
        return this.getDisplayText();
    }

    @Override
    public int getCaretPosition() {
        return 0;
    }

    @Override
    public CompletionPaintComponent getPaintComponent() {
        if (this.component == null) {
            this.component = new CompletionPaintComponent.DefaultCompletionPaintComponent(this);
        }
        return this.component;
    }

    public void setSortPriority(int sortPriority) {
        this.endTagSortPriority = sortPriority;
    }

    @Override
    public int getSortPriority() {
        return this.endTagSortPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(JTextComponent component) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        final int dotPos = component.getCaretPosition();
        final Indent indent = Indent.get((Document)doc);
        indent.lock();
        try {
            doc.runAtomic(new Runnable(){
                final /* synthetic */ EndTagResultItem this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        int startOffset = Utilities.getRowStart((BaseDocument)doc, (int)dotPos);
                        int endOffset = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
                        indent.reindent(startOffset, endOffset);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    @Override
    protected void replaceText(final JTextComponent component, final String text, final int offset, final int len) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        doc.runAtomic(new Runnable(){
            final /* synthetic */ EndTagResultItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                    this.this$0.tokenSequence = tokenHierarchy.tokenSequence();
                    String insertingText = this.this$0.getInsertingText(component, offset, text, len);
                    if (len > 0) {
                        doc.remove(offset, len);
                    }
                    doc.insertString(offset, insertingText, null);
                    if (!text.isEmpty() && !insertingText.isEmpty()) {
                        int caretPos;
                        tokenHierarchy = TokenHierarchy.get((Document)doc);
                        this.this$0.tokenSequence = tokenHierarchy.tokenSequence();
                        this.this$0.tokenSequence.move(offset);
                        this.this$0.tokenSequence.movePrevious();
                        Token token = this.this$0.tokenSequence.token();
                        if (CompletionUtil.isTagLastChar(token) && (caretPos = component.getCaretPosition() - text.length()) > -1) {
                            component.setCaretPosition(caretPos);
                        }
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
                }
            }
        });
        this.reindent(component);
    }
}

