/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.CharConversionException;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.refactoring.AttributeValueFinder;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.xml.XMLUtil;

public class JavaElementRefFinder {
    private final SpringConfigModel.DocumentAccess docAccess;
    private final SyntaxSupport syntaxSupport;

    public JavaElementRefFinder(SpringConfigModel.DocumentAccess docAccess) {
        this.docAccess = docAccess;
        BaseDocument document = (BaseDocument)docAccess.getDocument();
        this.syntaxSupport = document.getSyntaxSupport();
    }

    public void addOccurrences(Matcher matcher, List<Occurrences.Occurrence> result) throws BadLocationException {
        List<SpringBean> beans = this.docAccess.getSpringBeans().getFileBeans(this.docAccess.getFileObject()).getBeans();
        for (SpringBean bean : beans) {
            Occurrences.Occurrence occurrence;
            String matched;
            String className = bean.getClassName();
            if (className == null || (matched = matcher.accept(className)) == null || (occurrence = this.createClassOccurrence(matched, bean)) == null) continue;
            result.add(occurrence);
        }
    }

    private Occurrences.Occurrence createClassOccurrence(String matched, SpringBean bean) throws BadLocationException {
        Location loc = bean.getLocation();
        if (loc == null) {
            return null;
        }
        int startOffset = loc.getOffset();
        if (startOffset == -1) {
            return null;
        }
        AttributeValueFinder finder = new AttributeValueFinder(this.syntaxSupport, startOffset);
        if (!finder.find("class")) {
            return null;
        }
        int foundOffset = finder.getFoundOffset();
        String foundValue = finder.getValue();
        int index = foundValue.indexOf(matched);
        if (index == -1) {
            return null;
        }
        String displayText = this.createClassDisplayText(finder, foundValue, index, matched.length());
        PositionRef startRef = this.docAccess.createPositionRef(foundOffset + index, Position.Bias.Forward);
        PositionRef endRef = this.docAccess.createPositionRef(foundOffset + index + matched.length(), Position.Bias.Backward);
        return new JavaElementRefOccurrence(displayText, this.docAccess.getFileObject(), new PositionBounds(startRef, endRef));
    }

    private String createClassDisplayText(AttributeValueFinder finder, String classAttrValue, int matchIndex, int matchLength) throws BadLocationException {
        StringBuilder builder = new StringBuilder();
        builder.append("&lt;bean");
        String attrWithValue = this.getAttributeWithValue(finder, "id");
        if (attrWithValue == null) {
            attrWithValue = this.getAttributeWithValue(finder, "name");
        }
        if (attrWithValue != null) {
            builder.append(' ');
            builder.append(attrWithValue);
        }
        String beforeMatch = this.escapeAttrValue(classAttrValue.substring(0, matchIndex));
        String match = this.escapeAttrValue(classAttrValue.substring(matchIndex, matchIndex + matchLength));
        String afterMatch = this.escapeAttrValue(classAttrValue.substring(matchIndex + matchLength));
        if (beforeMatch != null && match != null && afterMatch != null) {
            builder.append(" class=");
            builder.append(beforeMatch).append("<b>").append(match).append("</b>").append(afterMatch);
        }
        return builder.toString();
    }

    private String getAttributeWithValue(AttributeValueFinder finder, String attrName) throws BadLocationException {
        if (finder.find(attrName)) {
            return attrName + "=" + this.escapeAttrValue(finder.getValue());
        }
        return null;
    }

    private String escapeAttrValue(String attrValue) {
        try {
            return XMLUtil.toAttributeValue((String)attrValue);
        }
        catch (CharConversionException e) {
            return null;
        }
    }

    public static interface Matcher {
        public String accept(String var1);
    }

    private static final class JavaElementRefOccurrence
    extends Occurrences.Occurrence {
        private final String displayText;

        JavaElementRefOccurrence(String displayText, FileObject fo, PositionBounds bounds) {
            super(fo, bounds);
            this.displayText = displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }
    }
}

