/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.nodes.actions.EnableCDIProbeModeCookie;
import org.netbeans.modules.payara.common.nodes.actions.OpenURLActionCookie;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class EnableCDIProbeModeAction
extends NodeAction {
    private static final String WELD_PROBE_URL = "/weld-probe";
    private List<String> targets = new ArrayList<String>();

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            return;
        }
        this.targets.clear();
        for (Node n : nodes) {
            this.targets.add(n.getDisplayName());
        }
        String aDup = EnableCDIProbeModeAction.getDup(this.targets);
        if (null != aDup) {
            NotifyDescriptor.Message m = new NotifyDescriptor.Message((Object)NbBundle.getMessage(EnableCDIProbeModeAction.class, (String)"ERR_HAS_DUPS", (Object)aDup), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)m);
            return;
        }
        RequestProcessor enabler = new RequestProcessor("pf-enable-cdi-probe-mode");
        for (Node node : nodes) {
            EnableCDIProbeModeCookie uCookie = (EnableCDIProbeModeCookie)node.getCookie(EnableCDIProbeModeCookie.class);
            final OpenURLActionCookie oCookie = (OpenURLActionCookie)node.getCookie(OpenURLActionCookie.class);
            if (uCookie == null) continue;
            final Future<ResultString> result = uCookie.enableCDIProbeMode();
            Node pNode = node.getParentNode().getParentNode();
            final Node fnode = node;
            enabler.post(new Runnable(){
                final /* synthetic */ EnableCDIProbeModeAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        result.get(15000L, ServerUtilities.ACTION_TIMEOUT_UNIT);
                        if (oCookie != null) {
                            try {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(oCookie.getWebURL() + EnableCDIProbeModeAction.WELD_PROBE_URL));
                            }
                            catch (MalformedURLException ex) {
                                Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
                            }
                        }
                    }
                    catch (TimeoutException ex) {
                        Logger.getLogger("payara").log(Level.WARNING, "Enable CDI probe mode action timed out for {0}", fnode.getDisplayName());
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Exception ex) {
                        Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            EnableCDIProbeModeCookie cookie = (EnableCDIProbeModeCookie)node.getCookie(EnableCDIProbeModeCookie.class);
            if (cookie != null && !cookie.isRunning()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(EnableCDIProbeModeAction.class, (String)"LBL_EnableCDIProbeModeAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    static String getDup(List<String> targets) {
        HashMap<String, String> uniqTargets = new HashMap<String, String>();
        if (null == targets) {
            return null;
        }
        for (String target : targets) {
            String shortName;
            int colon = target.indexOf(":");
            if (-1 == colon) {
                colon = target.length();
            }
            if (uniqTargets.containsKey(shortName = target.substring(0, colon))) {
                return shortName;
            }
            uniqTargets.put(shortName, shortName);
        }
        return null;
    }
}

