/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.jsf.refactoring.DiffElement;
import org.netbeans.modules.web.jsf.refactoring.Modifications;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class JSFRefactoringUtils {
    private static final Logger LOGGER = Logger.getLogger(JSFRefactoringUtils.class.getName());
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private JSFRefactoringUtils() {
    }

    public static String getPackageName(FileObject folder) {
        assert (folder.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)folder, (String)"classpath/source").getResourceName(folder, '.', false);
    }

    public static String getPackageName(URL url) {
        File file = null;
        try {
            file = FileUtil.normalizeFile((File)Utilities.toFile((URI)url.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Cannot create package name for url " + url);
        }
        String suffix = "";
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) != null) {
                if ("".equals(suffix)) {
                    return JSFRefactoringUtils.getPackageName(fileObject);
                }
                String prefix = JSFRefactoringUtils.getPackageName(fileObject);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            suffix = URLDecoder.decode(file.getPath().substring(file.getPath().lastIndexOf(File.separatorChar) + 1)) + suffix;
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + url);
    }

    public static boolean containsRenamingPackage(String oldFQCN, String oldPackage, boolean renameSubpackages) {
        boolean contains = false;
        if (oldFQCN != null && oldPackage != null) {
            if (!renameSubpackages) {
                if (oldFQCN.startsWith(oldPackage) && oldFQCN.substring(oldPackage.length() + 1).indexOf(46) < 0 && oldFQCN.substring(oldPackage.length()).charAt(0) == '.') {
                    contains = true;
                }
            } else if (oldFQCN.startsWith(oldPackage) && oldFQCN.substring(oldPackage.length()).charAt(0) == '.') {
                contains = true;
            }
        }
        return contains;
    }

    public static void renamePackage(AbstractRefactoring refactoring, RefactoringElementsBag refactoringElements, FileObject folder, String oldFQPN, String newFQPN, boolean recursive) {
        Project project = FileOwnerQuery.getOwner((FileObject)folder);
        if (project != null) {
            List<Occurrences.OccurrenceItem> items = Occurrences.getPackageOccurrences(project, oldFQPN, newFQPN, recursive);
            Modifications modification = new Modifications();
            for (Occurrences.OccurrenceItem item : items) {
                Modifications.Difference difference = new Modifications.Difference(Modifications.Difference.Kind.CHANGE, item.getChangePosition().getBegin(), item.getChangePosition().getEnd(), item.getOldValue(), item.getNewValue(), item.getRenamePackageMessage());
                modification.addDifference(item.getFacesConfig(), difference);
                refactoringElements.add(refactoring, (RefactoringElementImplementation)new DiffElement.ChangeFQCNElement(difference, item, modification));
            }
        }
    }

    public static boolean isJavaFile(FileObject f) {
        return JAVA_MIME_TYPE.equals(f.getMIMEType());
    }

    public static Element resolveElement(ClasspathInfo cpInfo, AbstractRefactoring refactoring, final TreePathHandle treePathHandle) {
        final Element[] element = new Element[1];
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{treePathHandle.getFileObject()});
        try {
            source.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    element[0] = treePathHandle.resolveElement((CompilationInfo)info);
                }
            }, true);
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Exception by refactoring:", exception);
        }
        return element[0];
    }
}

