/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.text.NbDocument;

public class SearchCompletionItem
implements CompletionItem {
    private final String word;

    public SearchCompletionItem(String word) {
        this.word = word;
    }

    public void defaultAction(final JTextComponent component) {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
        NbDocument.runAtomic((StyledDocument)((StyledDocument)component.getDocument()), (Runnable)new Runnable(){
            final /* synthetic */ SearchCompletionItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Document doc = component.getDocument();
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, this.this$0.getText(), null);
                }
                catch (BadLocationException e) {
                    Logger.getLogger(SearchCompletionItem.class.getName()).log(Level.FINE, null, e);
                }
            }
        });
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)SearchCompletionItem.escapeFirstLessThanSign(this.getText()), null, (Graphics)g, (Font)defaultFont);
    }

    private static String escapeFirstLessThanSign(String text) {
        String result = text;
        if (result != null && result.startsWith("<")) {
            result = "&lt;" + result.substring(1);
        }
        return result;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        if (selected) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
            g.setColor(defaultColor);
        }
        CompletionUtilities.renderHtml(null, (String)SearchCompletionItem.escapeFirstLessThanSign(this.getText()), null, (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return true;
    }

    public int getSortPriority() {
        return 100;
    }

    public CharSequence getSortText() {
        return this.getText();
    }

    protected String getText() {
        return this.word;
    }

    public CharSequence getInsertPrefix() {
        return this.getText();
    }

    public String toString() {
        return this.word;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.word != null ? this.word.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCompletionItem other = (SearchCompletionItem)obj;
        return !(this.word != null ? !this.word.equals(other.word) : other.word != null);
    }
}

