package Lire::UI::ReportSectionWidget;

use strict;

use base qw/ Lire::UI::CompoundWidget /;

use Lire::Utils qw/check_object_param/;
use Curses::UI::Common;
use Carp;

sub new {
    my ( $class, %userargs ) = @_;
    keys_to_lowercase(\%userargs);

    my $value = $userargs{'value'};
    check_object_param( $value, 'value', 'Lire::Config::Dictionary' );

    croak "'value' parameter's spec should be a 'Lire::Config::ReportSectionSpec' instance, not '", $value->spec(), "'"
      unless $value->spec()->isa( 'Lire::Config::ReportSectionSpec' );

    my $self =  $class->SUPER::new( %userargs );

    $self->getobj( 'superservice_widget' )->onValueChanged( sub { $self->update_spec_widgets() } );
    $self->update_spec_widgets();

    return $self;
}

sub update_spec_widgets {
    my $self = $_[0];

    my $superservice = $self->{'value'}->get( 'superservice' )->get();
    $self->getobj( 'filters_widget' )->superservice_filter( $superservice );
    $self->getobj( 'specs_widget' )->superservice_filter( $superservice );

    return;
}

1;
