/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.util;

import java.util.Map;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.provider.ProviderConfigurationBuilder;

public final class InfinispanUtils {
    private static final String INFINISPAN_VIRTUAL_THREADS_PROP = "org.infinispan.threads.virtual";
    private static final int MIN_VT_POOL_SIZE = 4;
    public static final int PROVIDER_ORDER = 1;
    public static final String EMBEDDED_PROVIDER_ID = "infinispan";
    public static final String REMOTE_PROVIDER_ID = "remote";
    public static final int DEFAULT_MAX_RETRIES = 10;
    private static final String CONFIG_MAX_RETRIES = "maxRetries";
    public static final int DEFAULT_RETRIES_BASE_TIME_MILLIS = 10;
    private static final String CONFIG_RETRIES_BASE_TIME_MILLIS = "retryBaseTime";

    private InfinispanUtils() {
    }

    public static boolean isRemoteInfinispan() {
        return MultiSiteUtils.isMultiSiteEnabled() || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLUSTERLESS);
    }

    public static boolean isEmbeddedInfinispan() {
        return !InfinispanUtils.isRemoteInfinispan();
    }

    public static void configureMaxRetries(ProviderConfigurationBuilder builder) {
        builder.property().name(CONFIG_MAX_RETRIES).type("int").helpText("The maximum number of retries if an error occurs. A value of zero or less disable any retries.").defaultValue((Object)10).add();
    }

    public static void configureRetryBaseTime(ProviderConfigurationBuilder builder) {
        builder.property().name(CONFIG_RETRIES_BASE_TIME_MILLIS).type("int").helpText("The base back-off time in milliseconds.").defaultValue((Object)10).add();
    }

    public static int getMaxRetries(Config.Scope config) {
        return Math.max(0, config.getInt(CONFIG_MAX_RETRIES, Integer.valueOf(10)));
    }

    public static int getRetryBaseTimeMillis(Config.Scope config) {
        return Math.max(1, config.getInt(CONFIG_RETRIES_BASE_TIME_MILLIS, Integer.valueOf(10)));
    }

    public static void maxRetriesToOperationalInfo(Map<String, String> map, int value) {
        map.put(CONFIG_MAX_RETRIES, Integer.toString(value));
    }

    public static void retryBaseTimeMillisToOperationalInfo(Map<String, String> map, int value) {
        map.put(CONFIG_RETRIES_BASE_TIME_MILLIS, Integer.toString(value));
    }

    public static boolean isVirtualThreadsEnabled() {
        return Boolean.parseBoolean(System.getProperty(INFINISPAN_VIRTUAL_THREADS_PROP));
    }

    public static void configureVirtualThreads() {
        if (System.getProperty(INFINISPAN_VIRTUAL_THREADS_PROP) == null && InfinispanUtils.getParallelism() >= 4) {
            System.setProperty(INFINISPAN_VIRTUAL_THREADS_PROP, "true");
        }
    }

    public static void ensureVirtualThreadsParallelism() {
        if (InfinispanUtils.isVirtualThreadsEnabled()) {
            if (InfinispanUtils.getParallelism() < 4) {
                throw new RuntimeException("To be able to use Infinispan/JGroups virtual threads, you need to set the Java system property jdk.virtualThreadScheduler.parallelism to at least 4");
            }
            if (InfinispanUtils.getMaxPoolSize() < 4) {
                throw new RuntimeException("To be able to use Infinispan/JGroups virtual threads, you need to set the Java system property jdk.virtualThreadScheduler.maxPoolSize to at least 4");
            }
        }
    }

    private static int getMaxPoolSize() {
        String maxPoolSizeValue = System.getProperty("jdk.virtualThreadScheduler.maxPoolSize");
        if (maxPoolSizeValue != null) {
            return Integer.parseInt(maxPoolSizeValue);
        }
        return Integer.MAX_VALUE;
    }

    private static int getParallelism() {
        String parallelismValue = System.getProperty("jdk.virtualThreadScheduler.parallelism");
        int parallelism = parallelismValue != null ? Integer.parseInt(parallelismValue) : Runtime.getRuntime().availableProcessors();
        return parallelism;
    }
}

