/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import org.hibernate.Incubating;
import org.hibernate.query.sqm.function.NamedSqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.function.SqmSetReturningFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;

@Incubating
public class NamedSetReturningFunctionDescriptorBuilder {
    private final SqmFunctionRegistry registry;
    private final String registrationKey;
    private final String functionName;
    private final SetReturningFunctionTypeResolver setReturningTypeResolver;
    private ArgumentsValidator argumentsValidator;
    private FunctionArgumentTypeResolver argumentTypeResolver;
    private String argumentListSignature;
    private SqlAstNodeRenderingMode argumentRenderingMode = SqlAstNodeRenderingMode.DEFAULT;

    public NamedSetReturningFunctionDescriptorBuilder(SqmFunctionRegistry registry, String registrationKey, String functionName, SetReturningFunctionTypeResolver typeResolver) {
        this.registry = registry;
        this.registrationKey = registrationKey;
        this.functionName = functionName;
        this.setReturningTypeResolver = typeResolver;
    }

    public NamedSetReturningFunctionDescriptorBuilder setArgumentsValidator(ArgumentsValidator argumentsValidator) {
        this.argumentsValidator = argumentsValidator;
        return this;
    }

    public NamedSetReturningFunctionDescriptorBuilder setArgumentTypeResolver(FunctionArgumentTypeResolver argumentTypeResolver) {
        this.argumentTypeResolver = argumentTypeResolver;
        return this;
    }

    public NamedSetReturningFunctionDescriptorBuilder setArgumentCountBetween(int min, int max) {
        return this.setArgumentsValidator(StandardArgumentsValidators.between(min, max));
    }

    public NamedSetReturningFunctionDescriptorBuilder setExactArgumentCount(int exactArgumentCount) {
        return this.setArgumentsValidator(StandardArgumentsValidators.exactly(exactArgumentCount));
    }

    public NamedSetReturningFunctionDescriptorBuilder setMinArgumentCount(int min) {
        return this.setArgumentsValidator(StandardArgumentsValidators.min(min));
    }

    public NamedSetReturningFunctionDescriptorBuilder setParameterTypes(FunctionParameterType ... types) {
        this.setArgumentsValidator(new ArgumentTypesValidator(this.argumentsValidator, types));
        this.setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.invariant(types));
        return this;
    }

    public NamedSetReturningFunctionDescriptorBuilder setArgumentListSignature(String argumentListSignature) {
        this.argumentListSignature = argumentListSignature;
        return this;
    }

    public NamedSetReturningFunctionDescriptorBuilder setArgumentRenderingMode(SqlAstNodeRenderingMode argumentRenderingMode) {
        this.argumentRenderingMode = argumentRenderingMode;
        return this;
    }

    public SqmSetReturningFunctionDescriptor register() {
        return this.registry.register(this.registrationKey, this.descriptor());
    }

    public SqmSetReturningFunctionDescriptor descriptor() {
        return new NamedSqmSetReturningFunctionDescriptor(this.functionName, this.argumentsValidator, this.setReturningTypeResolver, this.argumentTypeResolver, this.registrationKey, this.argumentListSignature, this.argumentRenderingMode);
    }
}

