/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.yaml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.infinispan.commons.configuration.io.AbstractConfigurationWriter;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationWriterException;
import org.infinispan.commons.configuration.io.NamingStrategy;

public class YamlConfigurationWriter
extends AbstractConfigurationWriter {
    public static final int INDENT = 2;
    private boolean openTag;
    private boolean attributes;
    private boolean array;

    public YamlConfigurationWriter(Writer writer, boolean clearTextSecrets) {
        super(writer, 2, true, clearTextSecrets, NamingStrategy.CAMEL_CASE);
    }

    @Override
    public void writeStartDocument() {
    }

    @Override
    public void writeStartElement(String name) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, false, true, true), this.naming);
    }

    private void writeStartElement0(AbstractConfigurationWriter.Tag tag, NamingStrategy naming) {
        try {
            if (this.openTag) {
                this.nl();
            }
            AbstractConfigurationWriter.Tag parent = (AbstractConfigurationWriter.Tag)this.tagStack.peek();
            this.tagStack.push(tag);
            this.tab();
            if (parent != null && parent.isRepeating()) {
                this.writer.write("- ");
                this.array = true;
            } else {
                this.array = false;
                this.writeName(tag.getName(), naming);
            }
            this.attributes = false;
            this.openTag = true;
            this.indent();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    private void writeName(String name, NamingStrategy naming) throws IOException {
        this.writer.write(naming.convert(name));
        this.writer.write(": ");
    }

    @Override
    public void writeStartElement(String prefix, String namespace, String name) {
        this.writeStartElement(this.prefixName(prefix, namespace, name));
    }

    private String prefixName(String prefix, String namespace, String name) {
        if (prefix == null) {
            return name;
        }
        if (this.namespaces.containsKey(prefix)) {
            return prefix + ":" + name;
        }
        return namespace + ":" + name;
    }

    @Override
    public void writeStartArrayElement(String name) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, true, true, false), this.naming);
    }

    @Override
    public void writeEndArrayElement() {
        this.writeEndElement();
    }

    @Override
    public void writeStartListElement(String name, boolean explicit) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, true, explicit, true), this.naming);
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, String name, boolean explicit) {
        this.writeStartListElement(this.prefixName(prefix, namespace, name), explicit);
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeDefaultNamespace(String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
    }

    @Override
    public void writeEndElement() {
        try {
            if (this.openTag && !this.attributes) {
                this.writer.write(126);
                this.nl();
            }
            this.openTag = false;
            this.attributes = false;
            this.tagStack.pop();
            this.outdent();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEndDocument() {
        if (!this.tagStack.isEmpty()) {
            throw new ConfigurationWriterException("Tag stack not empty: " + String.valueOf(this.tagStack));
        }
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, String value) {
        this.writeAttribute(name, value, true);
    }

    private void writeAttribute(String name, String value, boolean rename) {
        try {
            this.openTag = false;
            if (!this.attributes) {
                if (!this.array) {
                    this.nl();
                }
                this.attributes = true;
            }
            if (!this.array) {
                this.tab();
            }
            this.array = false;
            this.writer.write(rename ? this.naming.convert(name) : name);
            if (value != null) {
                this.writer.write(": \"");
                this.writer.write(YamlConfigurationWriter.escapeYAML(value));
                this.writer.write(34);
            } else {
                this.writer.write(": ~");
            }
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, Iterable<String> values) {
        try {
            this.openTag = false;
            if (!this.attributes) {
                this.nl();
                this.attributes = true;
            }
            this.tab();
            this.writer.write(this.naming.convert(name));
            this.writer.write(":");
            if (!values.iterator().hasNext()) {
                this.writer.write(" ~");
                this.nl();
            } else {
                this.nl();
                this.indent();
                for (String value : values) {
                    this.tab();
                    this.writer.write("- \"");
                    this.writer.write(YamlConfigurationWriter.escapeYAML(value));
                    this.writer.write(34);
                    this.nl();
                }
                this.outdent();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    private static String escapeYAML(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append("\\'");
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void writeArrayElement(String outer, String inner, String attribute, Iterable<String> values) {
        try {
            Iterator<String> it = values.iterator();
            if (it.hasNext()) {
                this.writeStartElement(outer);
                this.nl();
                while (it.hasNext()) {
                    this.tab();
                    this.writer.write("- \"");
                    this.writer.write(YamlConfigurationWriter.escapeYAML(it.next()));
                    this.writer.write(34);
                    this.nl();
                }
                this.openTag = false;
                this.writeEndElement();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeCharacters(String chars) {
        try {
            if (this.attributes) {
                this.writeAttribute("value", chars);
            } else {
                this.writer.write("\"");
                this.writer.write(chars);
                this.writer.write(34);
                this.nl();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEmptyElement(String name) {
        this.writeStartElement(name);
        this.writeEndElement();
    }

    @Override
    public void writeComment(String comment) {
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartMap(String name) {
        this.writeStartElement(name);
    }

    @Override
    public void writeMapItem(String element, String name, String key, String value) {
        this.writeAttribute(key, value, false);
    }

    @Override
    public void writeMapItem(String element, String name, String key) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(key, false, true, true), NamingStrategy.IDENTITY);
        this.writeStartElement(element);
    }

    @Override
    public void writeEndMapItem() {
        this.writeEndElement();
        this.writeEndElement();
    }

    @Override
    public void writeEndMap() {
        this.writeEndElement();
    }

    @Override
    public boolean hasFeature(ConfigurationFormatFeature feature) {
        return false;
    }
}

