/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.LiquibaseSqlParser;
import liquibase.util.StringClauses;
import liquibase.util.grammar.SimpleCharStream;
import liquibase.util.grammar.SimpleSqlGrammar;
import liquibase.util.grammar.SimpleSqlGrammarTokenManager;
import liquibase.util.grammar.Token;
import org.apache.commons.lang3.StringUtils;

public class StandardSqlParser
implements LiquibaseSqlParser {
    @Override
    public StringClauses parse(String sqlBlock) {
        return this.parse(sqlBlock, false, false);
    }

    @Override
    public StringClauses parse(String sqlBlock, boolean preserveWhitespace, boolean preserveComments) {
        return this.parse(sqlBlock, preserveWhitespace, preserveComments, null);
    }

    @Override
    public StringClauses parse(String sqlBlock, boolean preserveWhitespace, boolean preserveComments, ChangeSet changeSet) {
        StringClauses clauses = new StringClauses(preserveWhitespace ? "" : " ");
        SimpleSqlGrammarTokenManager tokenManager = new SimpleSqlGrammarTokenManager(new SimpleCharStream(new StringReader(sqlBlock)));
        SimpleSqlGrammar t = new SimpleSqlGrammar(tokenManager);
        try {
            Token token = t.getNextToken();
            while (token != null && !token.toString().isEmpty()) {
                if (token.kind == 1) {
                    if (preserveWhitespace) {
                        clauses.append(new StringClauses.Whitespace(token.image));
                    }
                } else if (token.kind == 2 || token.kind == 3) {
                    if (preserveComments) {
                        String comment = token.image;
                        if (!preserveWhitespace && token.kind == 2 && !comment.endsWith("\n")) {
                            comment = comment + "\n";
                        }
                        clauses.append(new StringClauses.Comment(comment));
                    }
                } else {
                    clauses.append(token.image);
                }
                token = t.getNextToken();
            }
        }
        catch (Throwable e) {
            if (changeSet != null) {
                Change change = (Change)((Object)Scope.getCurrentScope().get("change", Change.class));
                String message = StandardSqlParser.enhanceExceptionMessage(changeSet, change, e);
                throw new UnexpectedLiquibaseException(message, e);
            }
            throw new UnexpectedLiquibaseException(e);
        }
        return clauses;
    }

    private static String enhanceExceptionMessage(ChangeSet changeSet, Change change, Throwable e) {
        if (!(change instanceof RawSQLChange) || e.getMessage() == null) {
            return changeSet.toString();
        }
        String message = changeSet.toString();
        try {
            String exceptionMessage = e.getMessage();
            Pattern p = Pattern.compile("(?i).* line ([\\d]+).*");
            Matcher m = p.matcher(exceptionMessage);
            String atLine = "";
            if (m.matches()) {
                atLine = m.group(1);
            }
            int startLine = ((RawSQLChange)change).getSqlStartLine();
            int endLine = ((RawSQLChange)change).getSqlEndLine();
            if (StringUtils.isEmpty((CharSequence)atLine)) {
                message = String.format("%s (lines %d-%d)", changeSet, startLine, endLine);
            } else {
                int actualAtLine = Integer.parseInt(atLine) + startLine - 1;
                message = String.format("%s (issue at line %d of lines %d-%d)", changeSet, actualAtLine, startLine, endLine);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

