/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm;

import jakarta.persistence.metamodel.Bindable;
import java.util.Locale;
import org.hibernate.metamodel.model.domain.PathSource;
import org.hibernate.query.sqm.PathElementException;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmExpressibleAccessor;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public interface SqmPathSource<J>
extends SqmExpressible<J>,
Bindable<J>,
SqmExpressibleAccessor<J>,
PathSource<J> {
    @Override
    public SqmDomainType<J> getPathType();

    @Override
    public SqmPathSource<?> findSubPathSource(String var1);

    @Override
    default public SqmPathSource<?> findSubPathSource(String name, boolean includeSubtypes) {
        return this.findSubPathSource(name);
    }

    default public SqmPathSource<?> getSubPathSource(String name) {
        PathSource subPathSource = this.findSubPathSource(name);
        if (subPathSource == null) {
            throw new PathElementException(String.format(Locale.ROOT, "Could not resolve attribute '%s' of '%s'", name, this.getExpressible().getTypeName()));
        }
        return subPathSource;
    }

    default public SqmPathSource<?> getSubPathSource(String name, boolean subtypes) {
        PathSource subPathSource = this.findSubPathSource(name, subtypes);
        if (subPathSource == null) {
            throw new PathElementException(String.format(Locale.ROOT, "Could not resolve attribute '%s' of '%s'", name, this.getExpressible().getTypeName()));
        }
        return subPathSource;
    }

    default public SqmPathSource<?> getIntermediatePathSource(SqmPathSource<?> pathSource) {
        return null;
    }

    public SqmPath<J> createSqmPath(SqmPath<?> var1, SqmPathSource<?> var2);

    @Override
    default public SqmBindableType<J> getExpressible() {
        return this.getPathType();
    }

    @Override
    default public SqmDomainType<J> getSqmType() {
        return this.getPathType();
    }

    default public boolean isGeneric() {
        return false;
    }
}

