/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.VolatileImage;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaBase;

public class VolatileImageBackgroundPainterStrategy
extends ImageBackgroundPainterStrategy {
    private VolatileImage bgImage;

    public VolatileImageBackgroundPainterStrategy(RTextAreaBase ta5) {
        super(ta5);
    }

    @Override
    protected void paintImage(Graphics g15, int x15, int y15) {
        if (this.bgImage != null) {
            do {
                int rc5;
                if ((rc5 = this.bgImage.validate(null)) == 1) {
                    this.renderImage(this.bgImage.getWidth(), this.bgImage.getHeight(), this.getScalingHint());
                }
                g15.drawImage(this.bgImage, x15, y15, null);
            } while (this.bgImage.contentsLost());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(int width, int height, int hint) {
        Image master = this.getMasterImage();
        if (master != null) {
            do {
                Image i15 = master.getScaledInstance(width, height, hint);
                this.tracker.addImage(i15, 1);
                try {
                    this.tracker.waitForID(1);
                }
                catch (InterruptedException e15) {
                    e15.printStackTrace();
                    this.bgImage = null;
                    return;
                }
                finally {
                    this.tracker.removeImage(i15, 1);
                }
                this.bgImage.getGraphics().drawImage(i15, 0, 0, null);
                this.tracker.addImage(this.bgImage, 0);
                try {
                    this.tracker.waitForID(0);
                }
                catch (InterruptedException e16) {
                    e16.printStackTrace();
                    this.bgImage = null;
                    return;
                }
                finally {
                    this.tracker.removeImage(this.bgImage, 0);
                }
            } while (this.bgImage.contentsLost());
        } else {
            this.bgImage = null;
        }
    }

    @Override
    protected void rescaleImage(int width, int height, int hint) {
        this.bgImage = this.getRTextAreaBase().createVolatileImage(width, height);
        if (this.bgImage == null && !GraphicsEnvironment.isHeadless()) {
            this.bgImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleVolatileImage(width, height);
        }
        if (this.bgImage != null) {
            this.renderImage(width, height, hint);
        }
    }
}

