/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

final class RtfToText {
    private Reader r;
    private StringBuilder sb;
    private StringBuilder controlWord;
    private int blockCount;
    private boolean inControlWord;

    private RtfToText(Reader r15) {
        this.r = r15;
        this.sb = new StringBuilder();
        this.controlWord = new StringBuilder();
        this.blockCount = 0;
        this.inControlWord = false;
    }

    private String convert() throws IOException {
        int i15 = this.r.read();
        if (i15 != 123) {
            throw new IOException("Invalid RTF file");
        }
        block7: while ((i15 = this.r.read()) != -1) {
            char ch4 = (char)i15;
            switch (ch4) {
                case '{': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('{');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    ++this.blockCount;
                    continue block7;
                }
                case '}': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('}');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    --this.blockCount;
                    continue block7;
                }
                case '\\': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        if (this.controlWord.length() == 0) {
                            this.sb.append('\\');
                            this.controlWord.setLength(0);
                            this.inControlWord = false;
                            continue block7;
                        }
                        this.endControlWord();
                        this.inControlWord = true;
                        continue block7;
                    }
                    this.inControlWord = true;
                    continue block7;
                }
                case ' ': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.endControlWord();
                        continue block7;
                    }
                    this.sb.append(' ');
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.blockCount != 0 || !this.inControlWord) continue block7;
                    this.endControlWord();
                    continue block7;
                }
            }
            if (this.blockCount != 0) continue;
            if (this.inControlWord) {
                this.controlWord.append(ch4);
                continue;
            }
            this.sb.append(ch4);
        }
        return this.sb.toString();
    }

    private void endControlWord() {
        String word = this.controlWord.toString();
        if ("par".equals(word) || "line".equals(word)) {
            this.sb.append('\n');
        } else if ("tab".equals(word)) {
            this.sb.append('\t');
        } else if (RtfToText.isUnicodeEscape(word)) {
            this.sb.append((char)Integer.valueOf(word.substring(1)).intValue());
        }
        this.controlWord.setLength(0);
        this.inControlWord = false;
    }

    private static boolean isUnicodeEscape(String controlWord) {
        if (controlWord.startsWith("u") && controlWord.length() > 1) {
            for (int i15 = 1; i15 < controlWord.length(); ++i15) {
                char ch4 = controlWord.charAt(i15);
                if (ch4 >= '0' && ch4 <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getPlainText(byte[] rtf) throws IOException {
        return RtfToText.getPlainText(new ByteArrayInputStream(rtf));
    }

    public static String getPlainText(File file2) throws IOException {
        return RtfToText.getPlainText(new BufferedReader(new FileReader(file2)));
    }

    public static String getPlainText(InputStream in4) throws IOException {
        return RtfToText.getPlainText(new InputStreamReader(in4, StandardCharsets.US_ASCII));
    }

    private static String getPlainText(Reader r15) throws IOException {
        try {
            RtfToText converter = new RtfToText(r15);
            String string = converter.convert();
            return string;
        }
        finally {
            r15.close();
        }
    }

    public static String getPlainText(String rtf) throws IOException {
        return RtfToText.getPlainText(new StringReader(rtf));
    }
}

