/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class MarkupTagCompletion
extends AbstractCompletion {
    private String name;
    private String desc;
    private String definedIn;
    private List<ParameterizedCompletion.Parameter> attrs;

    public MarkupTagCompletion(CompletionProvider provider, String name) {
        super(provider);
        this.name = name;
    }

    protected void addAttributes(StringBuilder sb5) {
        int attrCount = this.getAttributeCount();
        if (attrCount > 0) {
            sb5.append("<b>Attributes:</b><br>");
            sb5.append("<center><table width='90%'><tr><td>");
            for (int i15 = 0; i15 < attrCount; ++i15) {
                ParameterizedCompletion.Parameter attr = this.getAttribute(i15);
                sb5.append("&nbsp;&nbsp;&nbsp;<b>");
                sb5.append(attr.getName() != null ? attr.getName() : attr.getType());
                sb5.append("</b>&nbsp;");
                String desc = attr.getDescription();
                if (desc != null) {
                    sb5.append(desc);
                }
                sb5.append("<br>");
            }
            sb5.append("</td></tr></table></center><br><br>");
        }
    }

    protected void addDefinitionString(StringBuilder sb5) {
        sb5.append("<html><b>").append(this.name).append("</b>");
    }

    public List<ParameterizedCompletion.Parameter> getAttributes() {
        return this.attrs;
    }

    public ParameterizedCompletion.Parameter getAttribute(int index) {
        return this.attrs.get(index);
    }

    public int getAttributeCount() {
        return this.attrs == null ? 0 : this.attrs.size();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getReplacementText() {
        return this.getName();
    }

    @Override
    public String getSummary() {
        StringBuilder sb5 = new StringBuilder();
        this.addDefinitionString(sb5);
        this.possiblyAddDescription(sb5);
        this.addAttributes(sb5);
        this.possiblyAddDefinedIn(sb5);
        return sb5.toString();
    }

    protected void possiblyAddDefinedIn(StringBuilder sb5) {
        if (this.definedIn != null) {
            sb5.append("<hr>Defined in:");
            sb5.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected void possiblyAddDescription(StringBuilder sb5) {
        if (this.desc != null) {
            sb5.append("<hr><br>");
            sb5.append(this.desc);
            sb5.append("<br><br><br>");
        }
    }

    public void setDefinedIn(String definedIn) {
        this.definedIn = definedIn;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setAttributes(List<? extends ParameterizedCompletion.Parameter> attrs) {
        this.attrs = new ArrayList<ParameterizedCompletion.Parameter>(attrs);
    }
}

