/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.highlight.swing;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.highlight.swing.color.CodeAreaNonprintablesColorType;
import org.exbin.bined.swing.CodeAreaCharAssessor;
import org.exbin.bined.swing.CodeAreaColorAssessor;
import org.exbin.bined.swing.CodeAreaPaintState;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;

@ParametersAreNonnullByDefault
public class NonprintablesCodeAreaAssessor
implements CodeAreaColorAssessor,
CodeAreaCharAssessor {
    protected final CodeAreaColorAssessor parentColorAssessor;
    protected final CodeAreaCharAssessor parentCharAssessor;
    @Nullable
    protected Map<Character, Character> nonprintableCharactersMapping = null;
    protected boolean showNonprintables = true;
    @Nullable
    protected Color nonprintablesColor;
    @Nullable
    protected Color nonprintablesBackground;

    public NonprintablesCodeAreaAssessor(@Nullable CodeAreaColorAssessor parentColorAssessor, @Nullable CodeAreaCharAssessor parentCharAssessor) {
        this.parentColorAssessor = parentColorAssessor;
        this.parentCharAssessor = parentCharAssessor;
    }

    public boolean isShowNonprintables() {
        return this.showNonprintables;
    }

    public void setShowNonprintables(boolean showNonprintables) {
        this.showNonprintables = showNonprintables;
    }

    @Override
    public void startPaint(CodeAreaPaintState codeAreaPaintState) {
        if (this.nonprintableCharactersMapping == null) {
            this.buildNonprintableCharactersMapping();
        }
        CodeAreaColorsProfile colorsProfile = codeAreaPaintState.getColorsProfile();
        this.nonprintablesColor = colorsProfile.getColor(CodeAreaNonprintablesColorType.NONPRINTABLES_COLOR);
        if (this.nonprintablesColor == null) {
            Color textColor = colorsProfile.getColor(CodeAreaBasicColors.TEXT_COLOR);
            this.nonprintablesColor = new Color(textColor.getRed(), textColor.getGreen(), (textColor.getBlue() + 196) % 256);
        }
        this.nonprintablesBackground = colorsProfile.getColor(CodeAreaNonprintablesColorType.NONPRINTABLES_BACKGROUND);
        if (this.parentColorAssessor != null) {
            this.parentColorAssessor.startPaint(codeAreaPaintState);
        }
        if (this.parentCharAssessor != null) {
            this.parentCharAssessor.startPaint(codeAreaPaintState);
        }
    }

    @Override
    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        if (this.showNonprintables && section == BasicCodeAreaSection.TEXT_PREVIEW) {
            Character character;
            Character c15 = character = this.parentCharAssessor != null ? Character.valueOf(this.parentCharAssessor.getPreviewCharacter(rowDataPosition, byteOnRow, charOnRow, section)) : null;
            if (character != null && this.nonprintableCharactersMapping.containsKey(character)) {
                return this.nonprintablesColor;
            }
        }
        if (this.parentColorAssessor != null) {
            return this.parentColorAssessor.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean inSelection) {
        if (this.nonprintablesBackground != null && this.showNonprintables && section == BasicCodeAreaSection.TEXT_PREVIEW) {
            Character character;
            Character c15 = character = this.parentCharAssessor != null ? Character.valueOf(this.parentCharAssessor.getPreviewCharacter(rowDataPosition, byteOnRow, charOnRow, section)) : null;
            if (character != null && this.nonprintableCharactersMapping.containsKey(character)) {
                return this.nonprintablesBackground;
            }
        }
        if (this.parentColorAssessor != null) {
            return this.parentColorAssessor.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, inSelection);
        }
        return null;
    }

    @Override
    public char getPreviewCharacter(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section) {
        Character character;
        Character c15 = character = this.parentCharAssessor != null ? Character.valueOf(this.parentCharAssessor.getPreviewCharacter(rowDataPosition, byteOnRow, charOnRow, section)) : null;
        if (this.showNonprintables && section == BasicCodeAreaSection.TEXT_PREVIEW && character != null) {
            Character altChar = this.nonprintableCharactersMapping.get(character);
            return (altChar == null ? character : altChar).charValue();
        }
        return character == null ? (char)' ' : (char)character.charValue();
    }

    @Override
    public char getPreviewCursorCharacter(long rowDataPosition, int byteOnRow, int charOnRow, byte[] cursorData, int cursorDataLength, CodeAreaSection section) {
        Character character;
        Character c15 = character = this.parentCharAssessor != null ? Character.valueOf(this.parentCharAssessor.getPreviewCursorCharacter(rowDataPosition, byteOnRow, charOnRow, cursorData, cursorDataLength, section)) : null;
        if (this.showNonprintables && section == BasicCodeAreaSection.TEXT_PREVIEW && character != null) {
            Character altChar = this.nonprintableCharactersMapping.get(character);
            return (altChar == null ? character : altChar).charValue();
        }
        return character == null ? (char)' ' : (char)character.charValue();
    }

    @Override
    @Nonnull
    public Optional<CodeAreaCharAssessor> getParentCharAssessor() {
        return Optional.ofNullable(this.parentCharAssessor);
    }

    @Override
    @Nonnull
    public Optional<CodeAreaColorAssessor> getParentColorAssessor() {
        return Optional.ofNullable(this.parentColorAssessor);
    }

    protected void buildNonprintableCharactersMapping() {
        this.nonprintableCharactersMapping = new HashMap<Character, Character>();
        for (int i15 = 0; i15 < 32; ++i15) {
            this.nonprintableCharactersMapping.put(Character.valueOf((char)i15), Character.valueOf(Character.toChars(9216 + i15)[0]));
        }
        this.nonprintableCharactersMapping.put(Character.valueOf(' '), Character.valueOf(Character.toChars(183)[0]));
        this.nonprintableCharactersMapping.put(Character.valueOf('\t'), Character.valueOf(Character.toChars(187)[0]));
        this.nonprintableCharactersMapping.put(Character.valueOf('\r'), Character.valueOf(Character.toChars(164)[0]));
        this.nonprintableCharactersMapping.put(Character.valueOf('\n'), Character.valueOf(Character.toChars(182)[0]));
        this.nonprintableCharactersMapping.put(Character.valueOf(Character.toChars(127)[0]), Character.valueOf(Character.toChars(176)[0]));
    }
}

