/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CharsetStreamTranslator
extends InputStream {
    private static final String UNMAPPABLE_CHARACTER_ERROR = "Unmappable character should be handled automatically";
    private static final String MALFORMED_CHARACTER_ERROR = "Malformed character should be handled automatically";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int DEFAULT_MAX_BYTES_PER_CHAR = 8;
    public static final int BYTE_BUFFER_SIZE = 16;
    @Nonnull
    protected final CharsetEncoder encoder;
    @Nonnull
    protected final CharsetDecoder decoder;
    @Nonnull
    protected final InputStream source;
    @Nonnull
    protected final ByteBuffer inputBuffer;
    @Nonnull
    protected final ByteBuffer outputBuffer;
    @Nonnull
    protected final CharBuffer charBuffer;
    protected boolean endOfInput = false;
    protected int maxInputCharSize;
    protected int maxOutputCharSize;

    public CharsetStreamTranslator(Charset inputCharset, Charset outputCharset, InputStream source, int bufferSize) {
        CharsetEncoder outputEncoder;
        this.source = source;
        this.decoder = inputCharset.newDecoder();
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        try {
            outputEncoder = outputCharset.newEncoder();
        }
        catch (UnsupportedOperationException ex4) {
            outputEncoder = Charset.forName(DEFAULT_ENCODING).newEncoder();
        }
        this.encoder = outputEncoder;
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.maxInputCharSize = (int)this.decoder.maxCharsPerByte();
        if (this.maxInputCharSize < 0) {
            this.maxInputCharSize = 1;
        }
        this.maxOutputCharSize = (int)this.encoder.maxBytesPerChar();
        if (this.maxOutputCharSize < 0) {
            this.maxOutputCharSize = 1;
        }
        this.charBuffer = CharBuffer.allocate(bufferSize * 8);
        this.inputBuffer = ByteBuffer.allocate(bufferSize);
        this.inputBuffer.limit(0);
        this.outputBuffer = ByteBuffer.allocate(bufferSize * this.maxOutputCharSize * 8);
        this.outputBuffer.limit(0);
    }

    public CharsetStreamTranslator(Charset inputCharset, Charset outputCharset, InputStream source) {
        this(inputCharset, outputCharset, source, 16);
    }

    @Override
    public int read() throws IOException {
        boolean dataReady;
        boolean bl4 = dataReady = this.outputBuffer.remaining() > 0;
        if (!dataReady) {
            if (this.endOfInput) {
                return -1;
            }
            this.processNext();
            if (this.outputBuffer.remaining() == 0) {
                return -1;
            }
        }
        return this.outputBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int processed;
        int toProcess;
        for (processed = 0; processed < length; length -= toProcess, processed += toProcess) {
            int remaining = this.outputBuffer.remaining();
            if (remaining == 0) {
                if (this.endOfInput) {
                    return processed > 0 ? processed : -1;
                }
                this.processNext();
                remaining = this.outputBuffer.remaining();
                if (remaining == 0) {
                    return processed > 0 ? processed : -1;
                }
            }
            toProcess = Math.min(length, remaining);
            this.outputBuffer.get(buffer, offset, toProcess);
            offset += toProcess;
        }
        return processed;
    }

    public void processNext() {
        this.charBuffer.rewind();
        this.charBuffer.limit(this.charBuffer.capacity());
        do {
            this.loadFromInput();
            if (this.inputBuffer.remaining() == 0) {
                return;
            }
            this.decoder.reset();
            CoderResult decodeResult = this.decoder.decode(this.inputBuffer, this.charBuffer, this.endOfInput);
            if (decodeResult.isOverflow()) break;
            if (decodeResult.isError()) {
                if (this.charBuffer.position() != 0 || this.inputBuffer.remaining() <= 0) continue;
                this.inputBuffer.position(this.inputBuffer.position() + 1);
                continue;
            }
            if (decodeResult.isUnmappable()) {
                throw new IllegalStateException(UNMAPPABLE_CHARACTER_ERROR);
            }
            if (!decodeResult.isMalformed()) continue;
            throw new IllegalStateException(MALFORMED_CHARACTER_ERROR);
        } while (this.charBuffer.position() == 0);
        int chars = this.charBuffer.position();
        this.charBuffer.rewind();
        this.charBuffer.limit(chars);
        this.outputBuffer.limit(this.outputBuffer.capacity());
        this.outputBuffer.clear();
        while (this.charBuffer.remaining() > 0) {
            this.encoder.reset();
            CoderResult encodeResult = this.encoder.encode(this.charBuffer, this.outputBuffer, this.endOfInput);
            if (encodeResult.isOverflow()) {
                throw new IllegalStateException("Unexpected overflow character");
            }
            if (encodeResult.isError()) {
                throw new IllegalStateException("Unexpected error character");
            }
            if (encodeResult.isUnmappable()) {
                throw new IllegalStateException(UNMAPPABLE_CHARACTER_ERROR);
            }
            if (!encodeResult.isMalformed()) continue;
            throw new IllegalStateException(MALFORMED_CHARACTER_ERROR);
        }
        int length = this.outputBuffer.position();
        this.outputBuffer.rewind();
        this.outputBuffer.limit(length);
    }

    @Override
    public int available() throws IOException {
        int remaining = this.outputBuffer.remaining();
        if (remaining > 0) {
            return remaining;
        }
        return this.endOfInput ? 1 : 0;
    }

    private void loadFromInput() {
        byte[] buffer = this.inputBuffer.array();
        int remainingLength = this.inputBuffer.remaining();
        if (remainingLength > 0) {
            System.arraycopy(buffer, this.inputBuffer.position(), buffer, 0, remainingLength);
            this.inputBuffer.rewind();
            this.inputBuffer.limit(remainingLength);
            this.inputBuffer.position(remainingLength);
        } else {
            this.inputBuffer.rewind();
            this.inputBuffer.limit(0);
        }
        int position = this.inputBuffer.position();
        int toRead = this.inputBuffer.capacity() - this.inputBuffer.position();
        this.inputBuffer.limit(position + toRead);
        int offset = position;
        while (toRead > 0) {
            try {
                int red = this.source.read(buffer, offset, toRead);
                if (red < 0) {
                    this.inputBuffer.limit(offset);
                    this.endOfInput = true;
                    break;
                }
                offset += red;
                toRead -= red;
            }
            catch (IOException ex4) {
                Logger.getLogger(CharsetStreamTranslator.class.getName()).log(Level.SEVERE, null, ex4);
            }
        }
        this.inputBuffer.rewind();
    }
}

