/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class AppendableWriter<T extends Appendable>
extends Writer {
    private final T appendable;

    public AppendableWriter(T appendable) {
        this.appendable = appendable;
    }

    @Override
    public Writer append(char c15) throws IOException {
        this.appendable.append(c15);
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    public T getAppendable() {
        return this.appendable;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        IOUtils.checkFromIndexSize(cbuf, off, len);
        for (int i15 = 0; i15 < len; ++i15) {
            this.appendable.append(cbuf[off + i15]);
        }
    }

    @Override
    public void write(int c15) throws IOException {
        this.appendable.append((char)c15);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        Objects.requireNonNull(str, "str");
        this.appendable.append(str, off, off + len);
    }
}

