/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.analysis.ActionLabel;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.PredicateLabel;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.State;
import org.antlr.analysis.StateCluster;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFAFactory {
    NFA nfa = null;
    Rule currentRule = null;

    public Rule getCurrentRule() {
        return this.currentRule;
    }

    public void setCurrentRule(Rule currentRule) {
        this.currentRule = currentRule;
    }

    public NFAFactory(NFA nfa) {
        nfa.setFactory(this);
        this.nfa = nfa;
    }

    public NFAState newState() {
        int state;
        NFAState n15 = new NFAState(this.nfa);
        n15.stateNumber = state = this.nfa.getNewNFAStateNumber();
        this.nfa.addState(n15);
        n15.enclosingRule = this.currentRule;
        return n15;
    }

    public void optimizeAlternative(StateCluster alt) {
        NFAState s15 = alt.left;
        while (s15 != alt.right) {
            if (s15.endOfBlockStateNumber != -1) {
                s15 = this.nfa.getState(s15.endOfBlockStateNumber);
                continue;
            }
            Transition t15 = s15.transition[0];
            if (t15 instanceof RuleClosureTransition) {
                s15 = ((RuleClosureTransition)t15).followState;
                continue;
            }
            if (t15.label.isEpsilon() && !t15.label.isAction() && s15.getNumberOfTransitions() == 1) {
                NFAState epsilonTarget = (NFAState)t15.target;
                if (epsilonTarget.endOfBlockStateNumber == -1 && epsilonTarget.transition[0] != null) {
                    s15.setTransition0(epsilonTarget.transition[0]);
                }
            }
            s15 = (NFAState)t15.target;
        }
    }

    public StateCluster build_Atom(int label, GrammarAST associatedAST) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        left.associatedASTNode = associatedAST;
        right.associatedASTNode = associatedAST;
        this.transitionBetweenStates(left, right, label);
        StateCluster g15 = new StateCluster(left, right);
        return g15;
    }

    public StateCluster build_Atom(GrammarAST atomAST) {
        int tokenType = this.nfa.grammar.getTokenType(atomAST.getText());
        return this.build_Atom(tokenType, atomAST);
    }

    public StateCluster build_Set(IntSet set, GrammarAST associatedAST) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        left.associatedASTNode = associatedAST;
        right.associatedASTNode = associatedAST;
        Label label = new Label(set);
        Transition e15 = new Transition(label, (State)right);
        left.addTransition(e15);
        StateCluster g15 = new StateCluster(left, right);
        return g15;
    }

    public StateCluster build_Range(int a15, int b15) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        Label label = new Label(IntervalSet.of(a15, b15));
        Transition e15 = new Transition(label, (State)right);
        left.addTransition(e15);
        StateCluster g15 = new StateCluster(left, right);
        return g15;
    }

    public StateCluster build_CharLiteralAtom(GrammarAST charLiteralAST) {
        int c15 = Grammar.getCharValueFromGrammarCharLiteral(charLiteralAST.getText());
        return this.build_Atom(c15, charLiteralAST);
    }

    public StateCluster build_CharRange(String a15, String b15) {
        int from = Grammar.getCharValueFromGrammarCharLiteral(a15);
        int to4 = Grammar.getCharValueFromGrammarCharLiteral(b15);
        return this.build_Range(from, to4);
    }

    public StateCluster build_StringLiteralAtom(GrammarAST stringLiteralAST) {
        if (this.nfa.grammar.type == 1) {
            StringBuffer chars = Grammar.getUnescapedStringFromGrammarStringLiteral(stringLiteralAST.getText());
            NFAState first = this.newState();
            NFAState last = null;
            NFAState prev = first;
            for (int i15 = 0; i15 < chars.length(); ++i15) {
                char c15 = chars.charAt(i15);
                NFAState next = this.newState();
                this.transitionBetweenStates(prev, next, c15);
                prev = last = next;
            }
            return new StateCluster(first, last);
        }
        int tokenType = this.nfa.grammar.getTokenType(stringLiteralAST.getText());
        return this.build_Atom(tokenType, stringLiteralAST);
    }

    public StateCluster build_RuleRef(Rule refDef, NFAState ruleStart) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        RuleClosureTransition e15 = new RuleClosureTransition(refDef, ruleStart, right);
        left.addTransition(e15);
        StateCluster g15 = new StateCluster(left, right);
        return g15;
    }

    public StateCluster build_Epsilon() {
        NFAState left = this.newState();
        NFAState right = this.newState();
        this.transitionBetweenStates(left, right, -5);
        StateCluster g15 = new StateCluster(left, right);
        return g15;
    }

    public StateCluster build_SemanticPredicate(GrammarAST pred) {
        if (!pred.getText().toUpperCase().startsWith("synpred".toUpperCase())) {
            ++this.nfa.grammar.numberOfSemanticPredicates;
        }
        NFAState left = this.newState();
        NFAState right = this.newState();
        Transition e15 = new Transition(new PredicateLabel(pred), (State)right);
        left.addTransition(e15);
        StateCluster g15 = new StateCluster(left, right);
        return g15;
    }

    public StateCluster build_Action(GrammarAST action) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        Transition e15 = new Transition(new ActionLabel(action), (State)right);
        left.addTransition(e15);
        return new StateCluster(left, right);
    }

    public int build_EOFStates(Collection<Rule> rules) {
        int numberUnInvokedRules = 0;
        for (Rule r15 : rules) {
            NFAState endNFAState = r15.stopState;
            if (endNFAState.transition[0] != null) continue;
            this.build_EOFState(endNFAState);
            ++numberUnInvokedRules;
        }
        return numberUnInvokedRules;
    }

    private void build_EOFState(NFAState endNFAState) {
        NFAState end = this.newState();
        int label = -1;
        if (this.nfa.grammar.type == 1) {
            label = -2;
            end.setEOTTargetState(true);
        }
        Transition toEnd = new Transition(label, (State)end);
        endNFAState.addTransition(toEnd);
    }

    public StateCluster build_AB(StateCluster A11, StateCluster B11) {
        if (A11 == null) {
            return B11;
        }
        if (B11 == null) {
            return A11;
        }
        this.transitionBetweenStates(A11.right, B11.left, -5);
        StateCluster g15 = new StateCluster(A11.left, B11.right);
        return g15;
    }

    public StateCluster build_AlternativeBlockFromSet(StateCluster set) {
        if (set == null) {
            return null;
        }
        NFAState startOfAlt = this.newState();
        this.transitionBetweenStates(startOfAlt, set.left, -5);
        return new StateCluster(startOfAlt, set.right);
    }

    public StateCluster build_AlternativeBlock(List<StateCluster> alternativeStateClusters) {
        if (alternativeStateClusters == null || alternativeStateClusters.isEmpty()) {
            return null;
        }
        if (alternativeStateClusters.size() == 1) {
            StateCluster g15 = alternativeStateClusters.get(0);
            NFAState startOfAlt = this.newState();
            this.transitionBetweenStates(startOfAlt, g15.left, -5);
            return new StateCluster(startOfAlt, g15.right);
        }
        NFAState prevAlternative = null;
        NFAState firstAlt = null;
        NFAState blockEndNFAState = this.newState();
        blockEndNFAState.setDescription("end block");
        int altNum = 1;
        for (StateCluster g16 : alternativeStateClusters) {
            NFAState left = this.newState();
            left.setDescription("alt " + altNum + " of ()");
            this.transitionBetweenStates(left, g16.left, -5);
            this.transitionBetweenStates(g16.right, blockEndNFAState, -5);
            if (firstAlt == null) {
                firstAlt = left;
            } else {
                this.transitionBetweenStates(prevAlternative, left, -5);
            }
            prevAlternative = left;
            ++altNum;
        }
        StateCluster result = new StateCluster(firstAlt, blockEndNFAState);
        firstAlt.decisionStateType = 2;
        firstAlt.endOfBlockStateNumber = blockEndNFAState.stateNumber;
        return result;
    }

    public StateCluster build_Aoptional(StateCluster A11) {
        StateCluster g15;
        int n15 = this.nfa.grammar.getNumberOfAltsForDecisionNFA(A11.left);
        if (n15 == 1) {
            NFAState decisionState = A11.left;
            decisionState.setDescription("only alt of ()? block");
            NFAState emptyAlt = this.newState();
            emptyAlt.setDescription("epsilon path of ()? block");
            NFAState blockEndNFAState = this.newState();
            this.transitionBetweenStates(A11.right, blockEndNFAState, -5);
            blockEndNFAState.setDescription("end ()? block");
            this.transitionBetweenStates(decisionState, emptyAlt, -5);
            this.transitionBetweenStates(emptyAlt, blockEndNFAState, -5);
            decisionState.endOfBlockStateNumber = blockEndNFAState.stateNumber;
            blockEndNFAState.decisionStateType = 5;
            g15 = new StateCluster(decisionState, blockEndNFAState);
        } else {
            NFAState lastRealAlt = this.nfa.grammar.getNFAStateForAltOfDecision(A11.left, n15);
            NFAState emptyAlt = this.newState();
            emptyAlt.setDescription("epsilon path of ()? block");
            this.transitionBetweenStates(lastRealAlt, emptyAlt, -5);
            this.transitionBetweenStates(emptyAlt, A11.right, -5);
            A11.left.endOfBlockStateNumber = A11.right.stateNumber;
            A11.right.decisionStateType = 5;
            g15 = A11;
        }
        g15.left.decisionStateType = 3;
        return g15;
    }

    public StateCluster build_Aplus(StateCluster A11) {
        NFAState left = this.newState();
        NFAState blockEndNFAState = this.newState();
        blockEndNFAState.decisionStateType = 5;
        if (A11.right.decisionStateType == 5) {
            NFAState extraRightEdge = this.newState();
            this.transitionBetweenStates(A11.right, extraRightEdge, -5);
            A11.right = extraRightEdge;
        }
        this.transitionBetweenStates(A11.right, blockEndNFAState, -5);
        this.transitionBetweenStates(A11.right, A11.left, -5);
        this.transitionBetweenStates(left, A11.left, -5);
        A11.right.decisionStateType = 1;
        A11.left.decisionStateType = 2;
        A11.left.endOfBlockStateNumber = A11.right.stateNumber;
        StateCluster g15 = new StateCluster(left, blockEndNFAState);
        return g15;
    }

    public StateCluster build_Astar(StateCluster A11) {
        NFAState bypassDecisionState = this.newState();
        bypassDecisionState.setDescription("enter loop path of ()* block");
        NFAState optionalAlt = this.newState();
        optionalAlt.setDescription("epsilon path of ()* block");
        NFAState blockEndNFAState = this.newState();
        blockEndNFAState.decisionStateType = 5;
        if (A11.right.decisionStateType == 5) {
            NFAState extraRightEdge = this.newState();
            this.transitionBetweenStates(A11.right, extraRightEdge, -5);
            A11.right = extraRightEdge;
        }
        A11.right.setDescription("()* loopback");
        this.transitionBetweenStates(bypassDecisionState, A11.left, -5);
        this.transitionBetweenStates(bypassDecisionState, optionalAlt, -5);
        this.transitionBetweenStates(optionalAlt, blockEndNFAState, -5);
        this.transitionBetweenStates(A11.right, blockEndNFAState, -5);
        this.transitionBetweenStates(A11.right, A11.left, -5);
        bypassDecisionState.decisionStateType = 4;
        A11.left.decisionStateType = 2;
        A11.right.decisionStateType = 1;
        A11.left.endOfBlockStateNumber = A11.right.stateNumber;
        bypassDecisionState.endOfBlockStateNumber = blockEndNFAState.stateNumber;
        StateCluster g15 = new StateCluster(bypassDecisionState, blockEndNFAState);
        return g15;
    }

    public StateCluster build_Wildcard(GrammarAST associatedAST) {
        NFAState left = this.newState();
        NFAState right = this.newState();
        left.associatedASTNode = associatedAST;
        right.associatedASTNode = associatedAST;
        Label label = new Label(this.nfa.grammar.getTokenTypes());
        Transition e15 = new Transition(label, (State)right);
        left.addTransition(e15);
        StateCluster g15 = new StateCluster(left, right);
        return g15;
    }

    public StateCluster build_WildcardTree(GrammarAST associatedAST) {
        StateCluster wildRoot = this.build_Wildcard(associatedAST);
        StateCluster down = this.build_Atom(2, associatedAST);
        wildRoot = this.build_AB(wildRoot, down);
        StateCluster wildChildren = this.build_Wildcard(associatedAST);
        wildChildren = this.build_Aplus(wildChildren);
        wildRoot = this.build_AB(wildRoot, wildChildren);
        StateCluster up4 = this.build_Atom(3, associatedAST);
        wildRoot = this.build_AB(wildRoot, up4);
        StateCluster optionalNodeAlt = this.build_Wildcard(associatedAST);
        ArrayList<StateCluster> alts = new ArrayList<StateCluster>();
        alts.add(wildRoot);
        alts.add(optionalNodeAlt);
        StateCluster blk = this.build_AlternativeBlock(alts);
        return blk;
    }

    protected IntSet getCollapsedBlockAsSet(State blk) {
        Label label;
        State s15;
        State s05 = blk;
        if (s05 != null && s05.transition(0) != null && (s15 = s05.transition((int)0).target) != null && s15.transition(0) != null && (label = s15.transition((int)0).label).isSet()) {
            return label.getSet();
        }
        return null;
    }

    private void transitionBetweenStates(NFAState a15, NFAState b15, int label) {
        Transition e15 = new Transition(label, (State)b15);
        a15.addTransition(e15);
    }
}

