/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.Utils;
import org.antlr.runtime.BitSet;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_SET = IntervalSet.of(0, 65535);
    protected List<Interval> intervals;

    public IntervalSet() {
        this.intervals = new ArrayList<Interval>(2);
    }

    public IntervalSet(List<Interval> intervals) {
        this.intervals = intervals;
    }

    public static IntervalSet of(int a15) {
        IntervalSet s15 = new IntervalSet();
        s15.add(a15);
        return s15;
    }

    public static IntervalSet of(int a15, int b15) {
        IntervalSet s15 = new IntervalSet();
        s15.add(a15, b15);
        return s15;
    }

    @Override
    public void add(int el4) {
        this.add(el4, el4);
    }

    public void add(int a15, int b15) {
        this.add(Interval.create(a15, b15));
    }

    protected void add(Interval addition) {
        if (addition.b < addition.a) {
            return;
        }
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval r15 = iter.next();
            if (addition.equals(r15)) {
                return;
            }
            if (addition.adjacent(r15) || !addition.disjoint(r15)) {
                Interval next;
                Interval bigger = addition.union(r15);
                iter.set(bigger);
                while (iter.hasNext() && (bigger.adjacent(next = iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union(next));
                    iter.next();
                }
                return;
            }
            if (!addition.startsBeforeDisjoint(r15)) continue;
            iter.previous();
            iter.add(addition);
            return;
        }
        this.intervals.add(addition);
    }

    @Override
    public void addAll(IntSet set) {
        if (set == null) {
            return;
        }
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't add non IntSet (" + set.getClass().getName() + ") to IntervalSet");
        }
        IntervalSet other = (IntervalSet)set;
        int n15 = other.intervals.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            Interval I11 = other.intervals.get(i15);
            this.add(I11.a, I11.b);
        }
    }

    public IntervalSet complement(int minElement, int maxElement) {
        return this.complement(IntervalSet.of(minElement, maxElement));
    }

    @Override
    public IntervalSet complement(IntSet vocabulary) {
        if (vocabulary == null) {
            return null;
        }
        if (!(vocabulary instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't complement with non IntervalSet (" + vocabulary.getClass().getName() + ")");
        }
        IntervalSet vocabularyIS = (IntervalSet)vocabulary;
        int maxElement = vocabularyIS.getMaxElement();
        IntervalSet compl = new IntervalSet();
        int n15 = this.intervals.size();
        if (n15 == 0) {
            return compl;
        }
        Interval first = this.intervals.get(0);
        if (first.a > 0) {
            IntervalSet s15 = IntervalSet.of(0, first.a - 1);
            IntervalSet a15 = s15.and(vocabularyIS);
            compl.addAll(a15);
        }
        for (int i15 = 1; i15 < n15; ++i15) {
            Interval previous = this.intervals.get(i15 - 1);
            Interval current = this.intervals.get(i15);
            IntervalSet s16 = IntervalSet.of(previous.b + 1, current.a - 1);
            IntervalSet a16 = s16.and(vocabularyIS);
            compl.addAll(a16);
        }
        Interval last = this.intervals.get(n15 - 1);
        if (last.b < maxElement) {
            IntervalSet s17 = IntervalSet.of(last.b + 1, maxElement);
            IntervalSet a17 = s17.and(vocabularyIS);
            compl.addAll(a17);
        }
        return compl;
    }

    @Override
    public IntervalSet subtract(IntSet other) {
        return this.and(((IntervalSet)other).complement(COMPLETE_SET));
    }

    @Override
    public IntSet or(IntSet a15) {
        IntervalSet o15 = new IntervalSet();
        o15.addAll(this);
        o15.addAll(a15);
        return o15;
    }

    @Override
    public IntervalSet and(IntSet other) {
        if (other == null) {
            return null;
        }
        List<Interval> myIntervals = this.intervals;
        List<Interval> theirIntervals = ((IntervalSet)other).intervals;
        IntervalSet intersection = null;
        int mySize = myIntervals.size();
        int theirSize = theirIntervals.size();
        int i15 = 0;
        int j15 = 0;
        while (i15 < mySize && j15 < theirSize) {
            Interval theirs;
            Interval mine = myIntervals.get(i15);
            if (mine.startsBeforeDisjoint(theirs = theirIntervals.get(j15))) {
                ++i15;
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                ++j15;
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++j15;
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++i15;
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet();
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                ++j15;
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            ++i15;
        }
        if (intersection == null) {
            return new IntervalSet();
        }
        return intersection;
    }

    @Override
    public boolean member(int el4) {
        int n15 = this.intervals.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            Interval I11 = this.intervals.get(i15);
            int a15 = I11.a;
            int b15 = I11.b;
            if (el4 < a15) break;
            if (el4 < a15 || el4 > b15) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        return this.intervals == null || this.intervals.isEmpty();
    }

    @Override
    public int getSingleElement() {
        if (this.intervals != null && this.intervals.size() == 1) {
            Interval I11 = this.intervals.get(0);
            if (I11.a == I11.b) {
                return I11.a;
            }
        }
        return -7;
    }

    public int getMaxElement() {
        if (this.isNil()) {
            return -7;
        }
        Interval last = this.intervals.get(this.intervals.size() - 1);
        return last.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            return -7;
        }
        int n15 = this.intervals.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            Interval I11 = this.intervals.get(i15);
            int a15 = I11.a;
            int b15 = I11.b;
            for (int v15 = a15; v15 <= b15; ++v15) {
                if (v15 < 0) continue;
                return v15;
            }
        }
        return -7;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IntervalSet)) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        return this.intervals.equals(other.intervals);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Grammar g15) {
        StringBuilder buf = new StringBuilder();
        if (this.intervals == null || this.intervals.isEmpty()) {
            return "{}";
        }
        if (this.intervals.size() > 1) {
            buf.append("{");
        }
        Iterator<Interval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I11 = iter.next();
            int a15 = I11.a;
            int b15 = I11.b;
            if (a15 == b15) {
                if (g15 != null) {
                    buf.append(g15.getTokenDisplayName(a15));
                } else {
                    buf.append(a15);
                }
            } else if (g15 != null) {
                buf.append(g15.getTokenDisplayName(a15)).append("..").append(g15.getTokenDisplayName(b15));
            } else {
                buf.append(a15).append("..").append(b15);
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.intervals.size() > 1) {
            buf.append("}");
        }
        return buf.toString();
    }

    @Override
    public int size() {
        int n15 = 0;
        int numIntervals = this.intervals.size();
        if (numIntervals == 1) {
            Interval firstInterval = this.intervals.get(0);
            return firstInterval.b - firstInterval.a + 1;
        }
        for (int i15 = 0; i15 < numIntervals; ++i15) {
            Interval I11 = this.intervals.get(i15);
            n15 += I11.b - I11.a + 1;
        }
        return n15;
    }

    @Override
    public List<Integer> toList() {
        ArrayList<Integer> values2 = new ArrayList<Integer>();
        int n15 = this.intervals.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            Interval I11 = this.intervals.get(i15);
            int a15 = I11.a;
            int b15 = I11.b;
            for (int v15 = a15; v15 <= b15; ++v15) {
                values2.add(Utils.integer(v15));
            }
        }
        return values2;
    }

    public int get(int i15) {
        int n15 = this.intervals.size();
        int index = 0;
        for (int j15 = 0; j15 < n15; ++j15) {
            Interval I11 = this.intervals.get(j15);
            int a15 = I11.a;
            int b15 = I11.b;
            for (int v15 = a15; v15 <= b15; ++v15) {
                if (index == i15) {
                    return v15;
                }
                ++index;
            }
        }
        return -1;
    }

    public int[] toArray() {
        int[] values2 = new int[this.size()];
        int n15 = this.intervals.size();
        int j15 = 0;
        for (int i15 = 0; i15 < n15; ++i15) {
            Interval I11 = this.intervals.get(i15);
            int a15 = I11.a;
            int b15 = I11.b;
            int v15 = a15;
            while (v15 <= b15) {
                values2[j15] = v15++;
                ++j15;
            }
        }
        return values2;
    }

    public BitSet toRuntimeBitSet() {
        BitSet s15 = new BitSet(this.getMaxElement() + 1);
        int n15 = this.intervals.size();
        for (int i15 = 0; i15 < n15; ++i15) {
            Interval I11 = this.intervals.get(i15);
            int a15 = I11.a;
            int b15 = I11.b;
            for (int v15 = a15; v15 <= b15; ++v15) {
                s15.add(v15);
            }
        }
        return s15;
    }

    @Override
    public void remove(int el4) {
        throw new NoSuchMethodError("IntervalSet.remove() unimplemented");
    }
}

