/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.checker.ClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.model.ArgumentList;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.DefinitelyNotNullTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentListMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleClassicTypeSystemContext
implements ClassicTypeSystemContext {
    @NotNull
    public static final SimpleClassicTypeSystemContext INSTANCE = new SimpleClassicTypeSystemContext();

    private SimpleClassicTypeSystemContext() {
    }

    @NotNull
    public KotlinTypeMarker default$makeNullable(KotlinTypeMarker $this$makeNullable) {
        Intrinsics.checkNotNullParameter($this$makeNullable, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$makeNullable);
        return rigidTypeMarker != null && (rigidTypeMarker = this.withNullability(rigidTypeMarker, true)) != null ? (KotlinTypeMarker)rigidTypeMarker : $this$makeNullable;
    }

    @Nullable
    public CapturedTypeMarker default$asCapturedTypeUnwrappingDnn(RigidTypeMarker $this$asCapturedTypeUnwrappingDnn) {
        Intrinsics.checkNotNullParameter($this$asCapturedTypeUnwrappingDnn, "<this>");
        return this.asCapturedType(this.originalIfDefinitelyNotNullable($this$asCapturedTypeUnwrappingDnn));
    }

    public boolean default$isCapturedType(KotlinTypeMarker $this$isCapturedType) {
        Intrinsics.checkNotNullParameter($this$isCapturedType, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$isCapturedType);
        return (rigidTypeMarker != null ? this.asCapturedTypeUnwrappingDnn(rigidTypeMarker) : null) != null;
    }

    @NotNull
    public SimpleTypeMarker default$originalIfDefinitelyNotNullable(RigidTypeMarker $this$originalIfDefinitelyNotNullable) {
        Intrinsics.checkNotNullParameter($this$originalIfDefinitelyNotNullable, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asDefinitelyNotNullType($this$originalIfDefinitelyNotNullable);
        if (rigidTypeMarker == null || (rigidTypeMarker = this.original((DefinitelyNotNullTypeMarker)rigidTypeMarker)) == null) {
            rigidTypeMarker = (SimpleTypeMarker)$this$originalIfDefinitelyNotNullable;
        }
        return rigidTypeMarker;
    }

    @NotNull
    public KotlinTypeMarker default$makeDefinitelyNotNullOrNotNull(KotlinTypeMarker $this$makeDefinitelyNotNullOrNotNull) {
        Intrinsics.checkNotNullParameter($this$makeDefinitelyNotNullOrNotNull, "<this>");
        return this.makeDefinitelyNotNullOrNotNull($this$makeDefinitelyNotNullOrNotNull, false);
    }

    @Nullable
    public TypeArgumentMarker default$getArgumentOrNull(RigidTypeMarker $this$getArgumentOrNull, int index) {
        Intrinsics.checkNotNullParameter($this$getArgumentOrNull, "<this>");
        boolean bl4 = 0 <= index ? index < this.argumentsCount($this$getArgumentOrNull) : false;
        if (bl4) {
            return this.getArgument($this$getArgumentOrNull, index);
        }
        return null;
    }

    @NotNull
    public RigidTypeMarker default$lowerBoundIfFlexible(KotlinTypeMarker $this$lowerBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$lowerBoundIfFlexible, "<this>");
        KotlinTypeMarker kotlinTypeMarker = this.asFlexibleType($this$lowerBoundIfFlexible);
        if (kotlinTypeMarker == null || (kotlinTypeMarker = this.lowerBound((FlexibleTypeMarker)kotlinTypeMarker)) == null) {
            RigidTypeMarker rigidTypeMarker = this.asRigidType($this$lowerBoundIfFlexible);
            kotlinTypeMarker = rigidTypeMarker;
            Intrinsics.checkNotNull(rigidTypeMarker);
        }
        return kotlinTypeMarker;
    }

    @NotNull
    public RigidTypeMarker default$upperBoundIfFlexible(KotlinTypeMarker $this$upperBoundIfFlexible) {
        Intrinsics.checkNotNullParameter($this$upperBoundIfFlexible, "<this>");
        KotlinTypeMarker kotlinTypeMarker = this.asFlexibleType($this$upperBoundIfFlexible);
        if (kotlinTypeMarker == null || (kotlinTypeMarker = this.upperBound((FlexibleTypeMarker)kotlinTypeMarker)) == null) {
            RigidTypeMarker rigidTypeMarker = this.asRigidType($this$upperBoundIfFlexible);
            kotlinTypeMarker = rigidTypeMarker;
            Intrinsics.checkNotNull(rigidTypeMarker);
        }
        return kotlinTypeMarker;
    }

    public boolean default$isFlexibleWithDifferentTypeConstructors(KotlinTypeMarker $this$isFlexibleWithDifferentTypeConstructors) {
        Intrinsics.checkNotNullParameter($this$isFlexibleWithDifferentTypeConstructors, "<this>");
        return !Intrinsics.areEqual(this.typeConstructor(this.lowerBoundIfFlexible($this$isFlexibleWithDifferentTypeConstructors)), this.typeConstructor(this.upperBoundIfFlexible($this$isFlexibleWithDifferentTypeConstructors)));
    }

    public boolean default$isFlexible(KotlinTypeMarker $this$isFlexible) {
        Intrinsics.checkNotNullParameter($this$isFlexible, "<this>");
        return this.asFlexibleType($this$isFlexible) != null;
    }

    public boolean default$isDynamic(KotlinTypeMarker $this$isDynamic) {
        Intrinsics.checkNotNullParameter($this$isDynamic, "<this>");
        FlexibleTypeMarker flexibleTypeMarker = this.asFlexibleType($this$isDynamic);
        return (flexibleTypeMarker != null ? this.asDynamicType(flexibleTypeMarker) : null) != null;
    }

    public boolean default$isDefinitelyNotNullType(KotlinTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotNullType, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$isDefinitelyNotNullType);
        return (rigidTypeMarker != null ? this.asDefinitelyNotNullType(rigidTypeMarker) : null) != null;
    }

    public boolean default$isDefinitelyNotNullType(RigidTypeMarker $this$isDefinitelyNotNullType) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotNullType, "<this>");
        return this.asDefinitelyNotNullType($this$isDefinitelyNotNullType) != null;
    }

    public boolean default$hasFlexibleNullability(KotlinTypeMarker $this$hasFlexibleNullability) {
        Intrinsics.checkNotNullParameter($this$hasFlexibleNullability, "<this>");
        return this.isMarkedNullable(this.lowerBoundIfFlexible($this$hasFlexibleNullability)) != this.isMarkedNullable(this.upperBoundIfFlexible($this$hasFlexibleNullability));
    }

    @NotNull
    public TypeConstructorMarker default$typeConstructor(KotlinTypeMarker $this$typeConstructor) {
        Intrinsics.checkNotNullParameter($this$typeConstructor, "<this>");
        RigidTypeMarker rigidTypeMarker = this.asRigidType($this$typeConstructor);
        if (rigidTypeMarker == null) {
            rigidTypeMarker = this.lowerBoundIfFlexible($this$typeConstructor);
        }
        return this.typeConstructor(rigidTypeMarker);
    }

    public boolean default$isNothing(KotlinTypeMarker $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return this.isNothingConstructor(this.typeConstructor($this$isNothing)) && !this.isNullableType($this$isNothing);
    }

    public boolean default$isClassType(RigidTypeMarker $this$isClassType) {
        Intrinsics.checkNotNullParameter($this$isClassType, "<this>");
        return this.isClassTypeConstructor(this.typeConstructor($this$isClassType));
    }

    @Nullable
    public List<SimpleTypeMarker> default$fastCorrespondingSupertypes(RigidTypeMarker $this$fastCorrespondingSupertypes, TypeConstructorMarker constructor) {
        Intrinsics.checkNotNullParameter($this$fastCorrespondingSupertypes, "<this>");
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        return null;
    }

    public boolean default$isIntegerLiteralType(RigidTypeMarker $this$isIntegerLiteralType) {
        Intrinsics.checkNotNullParameter($this$isIntegerLiteralType, "<this>");
        return this.isIntegerLiteralTypeConstructor(this.typeConstructor($this$isIntegerLiteralType));
    }

    @NotNull
    public TypeArgumentMarker default$get(TypeArgumentListMarker $this$get, int index) {
        TypeArgumentMarker typeArgumentMarker;
        Intrinsics.checkNotNullParameter($this$get, "<this>");
        TypeArgumentListMarker typeArgumentListMarker = $this$get;
        if (typeArgumentListMarker instanceof SimpleTypeMarker) {
            typeArgumentMarker = this.getArgument((KotlinTypeMarker)((Object)$this$get), index);
        } else if (typeArgumentListMarker instanceof ArgumentList) {
            Object e15 = ((ArgumentList)$this$get).get(index);
            Intrinsics.checkNotNullExpressionValue(e15, "get(...)");
            typeArgumentMarker = (TypeArgumentMarker)e15;
        } else {
            throw new IllegalStateException(("unknown type argument list type: " + $this$get + ", " + Reflection.getOrCreateKotlinClass($this$get.getClass())).toString());
        }
        return typeArgumentMarker;
    }

    public int default$size(TypeArgumentListMarker $this$size) {
        int n15;
        Intrinsics.checkNotNullParameter($this$size, "<this>");
        TypeArgumentListMarker typeArgumentListMarker = $this$size;
        if (typeArgumentListMarker instanceof RigidTypeMarker) {
            n15 = this.argumentsCount((KotlinTypeMarker)((Object)$this$size));
        } else if (typeArgumentListMarker instanceof ArgumentList) {
            n15 = ((ArgumentList)$this$size).size();
        } else {
            throw new IllegalStateException(("unknown type argument list type: " + $this$size + ", " + Reflection.getOrCreateKotlinClass($this$size.getClass())).toString());
        }
        return n15;
    }
}

