/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data;

import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.JavaMethodRef;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import jadx.plugins.input.java.data.attributes.types.CodeAttr;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationDefaultAttr;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationsAttr;
import jadx.plugins.input.java.data.attributes.types.JavaParamAnnsAttr;
import jadx.plugins.input.java.data.code.JavaCodeReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaMethodData
implements IMethodData {
    private final JavaClassData clsData;
    private final JavaMethodRef methodRef;
    private int accessFlags;
    private JavaAttrStorage attributes;

    public JavaMethodData(JavaClassData clsData, JavaMethodRef methodRef) {
        this.clsData = clsData;
        this.methodRef = methodRef;
    }

    public void setData(int accessFlags, JavaAttrStorage attributes) {
        this.accessFlags = accessFlags;
        this.attributes = attributes;
    }

    @Override
    public JavaMethodRef getMethodRef() {
        return this.methodRef;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nullable
    public ICodeReader getCodeReader() {
        CodeAttr codeAttr = this.attributes.get(JavaAttrType.CODE);
        if (codeAttr == null) {
            return null;
        }
        return new JavaCodeReader(this.clsData, codeAttr.getOffset());
    }

    @Override
    public String disassembleMethod() {
        return "";
    }

    @Override
    public List<IJadxAttribute> getAttributes() {
        int size = this.attributes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<IJadxAttribute> list2 = new ArrayList<IJadxAttribute>(size);
        Utils.addToList(list2, JavaAnnotationsAttr.merge(this.attributes));
        Utils.addToList(list2, JavaParamAnnsAttr.merge(this.attributes));
        Utils.addToList(list2, JavaAnnotationDefaultAttr.convert(this.attributes));
        Utils.addToList(list2, (IJadxAttribute)this.attributes.get(JavaAttrType.SIGNATURE));
        Utils.addToList(list2, (IJadxAttribute)this.attributes.get(JavaAttrType.EXCEPTIONS));
        Utils.addToList(list2, (IJadxAttribute)this.attributes.get(JavaAttrType.METHOD_PARAMETERS));
        return list2;
    }

    public String toString() {
        return this.getMethodRef().toString();
    }
}

