/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.smali;

import java.util.List;

public class SmaliCodeWriter {
    public static final String NL = System.getProperty("line.separator");
    public static final String INDENT_STR = "    ";
    private final StringBuilder code = new StringBuilder();
    private int indent;
    private String indentStr = "";

    public SmaliCodeWriter startLine(String line) {
        this.startLine();
        this.code.append(line);
        return this;
    }

    public SmaliCodeWriter startLine() {
        if (this.code.length() != 0) {
            this.code.append(NL);
            this.code.append(this.indentStr);
        }
        return this;
    }

    public SmaliCodeWriter add(Object obj) {
        this.code.append(obj);
        return this;
    }

    public SmaliCodeWriter add(int i15) {
        this.code.append(i15);
        return this;
    }

    public SmaliCodeWriter add(char c15) {
        this.code.append(c15);
        return this;
    }

    public SmaliCodeWriter add(String str) {
        this.code.append(str);
        return this;
    }

    public SmaliCodeWriter addArgs(List<String> argTypes) {
        for (String type : argTypes) {
            this.code.append(type);
        }
        return this;
    }

    public void incIndent() {
        ++this.indent;
        this.buildIndent();
    }

    public void decIndent() {
        --this.indent;
        this.buildIndent();
    }

    private void buildIndent() {
        StringBuilder s15 = new StringBuilder(this.indent * INDENT_STR.length());
        for (int i15 = 0; i15 < this.indent; ++i15) {
            s15.append(INDENT_STR);
        }
        this.indentStr = s15.toString();
    }

    public String getCode() {
        return this.code.toString();
    }
}

