/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections.debuginfo;

import jadx.api.plugins.input.data.ILocalVar;
import jadx.api.plugins.input.data.impl.DebugInfo;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.debuginfo.DexLocalVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DebugInfoParser {
    private static final int DBG_END_SEQUENCE = 0;
    private static final int DBG_ADVANCE_PC = 1;
    private static final int DBG_ADVANCE_LINE = 2;
    private static final int DBG_START_LOCAL = 3;
    private static final int DBG_START_LOCAL_EXTENDED = 4;
    private static final int DBG_END_LOCAL = 5;
    private static final int DBG_RESTART_LOCAL = 6;
    private static final int DBG_SET_PROLOGUE_END = 7;
    private static final int DBG_SET_EPILOGUE_BEGIN = 8;
    private static final int DBG_SET_FILE = 9;
    private static final int DBG_FIRST_SPECIAL = 10;
    private static final int DBG_LINE_BASE = -4;
    private static final int DBG_LINE_RANGE = 15;
    private final SectionReader in;
    private final SectionReader ext;
    private final DexLocalVar[] locals;
    private final int codeSize;
    private List<ILocalVar> resultList;
    private Map<Integer, Integer> linesMap;
    @Nullable
    private String sourceFile;
    private List<String> argTypes;
    private int[] argRegs;

    public DebugInfoParser(SectionReader in4, int regsCount, int codeSize) {
        this.in = in4;
        this.ext = in4.copy();
        this.locals = new DexLocalVar[regsCount];
        this.codeSize = codeSize;
    }

    public void initMthArgs(int regsCount, List<String> argTypes) {
        if (argTypes.isEmpty()) {
            this.argTypes = Collections.emptyList();
            return;
        }
        int argsCount = argTypes.size();
        int[] argRegsArr = new int[argsCount];
        int regNum = regsCount;
        for (int i15 = argsCount - 1; i15 >= 0; --i15) {
            argRegsArr[i15] = regNum -= DebugInfoParser.getTypeLen(argTypes.get(i15));
        }
        this.argRegs = argRegsArr;
        this.argTypes = argTypes;
    }

    public static int getTypeLen(String type) {
        switch (type.charAt(0)) {
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    public DebugInfo process(int debugOff) {
        int c15;
        this.in.absPos(debugOff);
        boolean varsInfoFound = false;
        this.resultList = new ArrayList<ILocalVar>();
        this.linesMap = new HashMap<Integer, Integer>();
        int addr = 0;
        int line = this.in.readUleb128();
        int paramsCount = this.in.readUleb128();
        int argsCount = this.argTypes.size();
        for (int i15 = 0; i15 < paramsCount; ++i15) {
            int nameId = this.in.readUleb128p1();
            String name = this.ext.getString(nameId);
            if (name == null || i15 >= argsCount) continue;
            DexLocalVar paramVar = new DexLocalVar(this.argRegs[i15], name, this.argTypes.get(i15));
            this.startVar(paramVar, addr);
            paramVar.markAsParameter();
            varsInfoFound = true;
        }
        block11: while ((c15 = this.in.readUByte()) != 0) {
            switch (c15) {
                case 1: {
                    int addrInc = this.in.readUleb128();
                    addr = this.addrChange(addr, addrInc);
                    continue block11;
                }
                case 2: {
                    line += this.in.readSleb128();
                    continue block11;
                }
                case 3: {
                    int regNum = this.in.readUleb128();
                    int nameId = this.in.readUleb128() - 1;
                    int type = this.in.readUleb128() - 1;
                    DexLocalVar var = new DexLocalVar(this.ext, regNum, nameId, type, -1);
                    this.startVar(var, addr);
                    varsInfoFound = true;
                    continue block11;
                }
                case 4: {
                    int regNum = this.in.readUleb128();
                    int nameId = this.in.readUleb128p1();
                    int type = this.in.readUleb128p1();
                    int sign = this.in.readUleb128p1();
                    DexLocalVar var = new DexLocalVar(this.ext, regNum, nameId, type, sign);
                    this.startVar(var, addr);
                    varsInfoFound = true;
                    continue block11;
                }
                case 6: {
                    int regNum = this.in.readUleb128();
                    this.restartVar(regNum, addr);
                    varsInfoFound = true;
                    continue block11;
                }
                case 5: {
                    int regNum = this.in.readUleb128();
                    DexLocalVar var = this.locals[regNum];
                    if (var != null) {
                        this.endVar(var, addr);
                    }
                    varsInfoFound = true;
                    continue block11;
                }
                case 7: 
                case 8: {
                    continue block11;
                }
                case 9: {
                    int idx = this.in.readUleb128() - 1;
                    this.sourceFile = this.ext.getString(idx);
                    continue block11;
                }
            }
            int adjustedOpCode = c15 - 10;
            int addrInc = adjustedOpCode / 15;
            addr = this.addrChange(addr, addrInc);
            this.setLine(addr, line += -4 + adjustedOpCode % 15);
        }
        if (varsInfoFound) {
            for (DexLocalVar var : this.locals) {
                if (var == null || var.isEnd()) continue;
                this.endVar(var, this.codeSize - 1);
            }
        }
        return new DebugInfo(this.linesMap, this.resultList);
    }

    private int addrChange(int addr, int addrInc) {
        return Math.min(addr + addrInc, this.codeSize - 1);
    }

    private void setLine(int offset, int line) {
        this.linesMap.put(offset, line);
    }

    private void restartVar(int regNum, int addr) {
        DexLocalVar prev = this.locals[regNum];
        if (prev != null) {
            this.endVar(prev, addr);
            DexLocalVar newVar = new DexLocalVar(regNum, prev.getName(), prev.getType(), prev.getSignature());
            this.startVar(newVar, addr);
        }
    }

    private void startVar(DexLocalVar newVar, int addr) {
        int regNum = newVar.getRegNum();
        DexLocalVar prev = this.locals[regNum];
        if (prev != null) {
            this.endVar(prev, addr);
        }
        newVar.start(addr);
        this.locals[regNum] = newVar;
    }

    private void endVar(DexLocalVar var, int addr) {
        if (var.end(addr)) {
            this.resultList.add(var);
        }
    }
}

