/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.aab.parsers;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.EntryConfig;
import jadx.core.xmlgen.entry.ProtoValue;
import java.util.ArrayList;

public class CommonProtoParser
extends ParserConstants {
    protected ProtoValue parse(Resources.Style s15) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(s15.getEntryCount());
        Object parent = s15.getParent().getName();
        parent = ((String)parent).isEmpty() ? null : "@" + (String)parent;
        for (int i15 = 0; i15 < s15.getEntryCount(); ++i15) {
            Resources.Style.Entry entry = s15.getEntry(i15);
            String name = entry.getKey().getName();
            String value = this.parse(entry.getItem());
            namedValues.add(new ProtoValue(value).setName(name));
        }
        return new ProtoValue().setNamedValues(namedValues).setParent((String)parent);
    }

    protected ProtoValue parse(Resources.Styleable s15) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(s15.getEntryCount());
        for (int i15 = 0; i15 < s15.getEntryCount(); ++i15) {
            Resources.Styleable.Entry e15 = s15.getEntry(i15);
            namedValues.add(new ProtoValue("@" + e15.getAttr().getName()));
        }
        return new ProtoValue().setNamedValues(namedValues);
    }

    protected ProtoValue parse(Resources.Array a15) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(a15.getElementCount());
        for (int i15 = 0; i15 < a15.getElementCount(); ++i15) {
            Resources.Array.Element e15 = a15.getElement(i15);
            String value = this.parse(e15.getItem());
            namedValues.add(new ProtoValue(value));
        }
        return new ProtoValue().setNamedValues(namedValues);
    }

    protected ProtoValue parse(Resources.Attribute a15) {
        String format = XmlGenUtils.getAttrTypeAsString(a15.getFormatFlags());
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(a15.getSymbolCount());
        for (int i15 = 0; i15 < a15.getSymbolCount(); ++i15) {
            Resources.Attribute.Symbol s15 = a15.getSymbol(i15);
            int type = s15.getType();
            String name = s15.getName().getName();
            String value = String.valueOf(s15.getValue());
            namedValues.add(new ProtoValue(value).setName(name).setType(type));
        }
        return new ProtoValue(format).setNamedValues(namedValues);
    }

    protected ProtoValue parse(Resources.Plural p15) {
        ArrayList<ProtoValue> namedValues = new ArrayList<ProtoValue>(p15.getEntryCount());
        for (int i15 = 0; i15 < p15.getEntryCount(); ++i15) {
            Resources.Plural.Entry e15 = p15.getEntry(i15);
            String name = e15.getArity().name();
            String value = this.parse(e15.getItem());
            namedValues.add(new ProtoValue(value).setName(name));
        }
        return new ProtoValue().setNamedValues(namedValues);
    }

    protected ProtoValue parse(Resources.CompoundValue c15) {
        switch (c15.getValueCase()) {
            case STYLE: {
                return this.parse(c15.getStyle());
            }
            case STYLEABLE: {
                return this.parse(c15.getStyleable());
            }
            case ARRAY: {
                return this.parse(c15.getArray());
            }
            case ATTR: {
                return this.parse(c15.getAttr());
            }
            case PLURAL: {
                return this.parse(c15.getPlural());
            }
        }
        return new ProtoValue("Unresolved value");
    }

    protected String parse(ConfigurationOuterClass.Configuration c15) {
        char[] language = c15.getLocale().toCharArray();
        if (language.length == 0) {
            language = new char[]{'\u0000'};
        }
        short mcc = (short)c15.getMcc();
        short mnc = (short)c15.getMnc();
        byte orientation = (byte)c15.getOrientationValue();
        short screenWidth = (short)c15.getScreenWidth();
        short screenHeight = (short)c15.getScreenHeight();
        short screenWidthDp = (short)c15.getScreenWidthDp();
        short screenHeightDp = (short)c15.getScreenHeightDp();
        short smallestScreenWidthDp = (short)c15.getSmallestScreenWidthDp();
        short sdkVersion = (short)c15.getSdkVersion();
        byte keyboard = (byte)c15.getKeyboardValue();
        byte touchscreen = (byte)c15.getTouchscreenValue();
        int density = c15.getDensity();
        byte screenLayout = (byte)c15.getScreenLayoutLongValue();
        byte colorMode = (byte)(c15.getHdrValue() | c15.getWideColorGamutValue());
        byte screenLayout2 = (byte)(c15.getLayoutDirectionValue() | c15.getScreenRoundValue());
        byte navigation = (byte)c15.getNavigationValue();
        byte inputFlags = (byte)(c15.getKeysHiddenValue() | c15.getNavHiddenValue());
        byte grammaticalInflection = (byte)c15.getGrammaticalGenderValue();
        int size = c15.getSerializedSize();
        byte uiMode = (byte)(c15.getUiModeNightValue() | c15.getUiModeTypeValue());
        c15.getScreenLayoutSize();
        c15.getProduct();
        return new EntryConfig(mcc, mnc, language, new char[]{'\u0000'}, orientation, touchscreen, density, keyboard, navigation, inputFlags, grammaticalInflection, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, new char[]{'\u0000'}, new char[]{'\u0000'}, screenLayout2, colorMode, false, size).getQualifiers();
    }

    protected String parse(Resources.Item i15) {
        if (i15.hasRawStr()) {
            return i15.getRawStr().getValue();
        }
        if (i15.hasStr()) {
            return i15.getStr().getValue();
        }
        if (i15.hasStyledStr()) {
            return i15.getStyledStr().getValue();
        }
        if (i15.hasPrim()) {
            Resources.Primitive prim = i15.getPrim();
            switch (prim.getOneofValueCase()) {
                case NULL_VALUE: {
                    return null;
                }
                case INT_DECIMAL_VALUE: {
                    return String.valueOf(prim.getIntDecimalValue());
                }
                case INT_HEXADECIMAL_VALUE: {
                    return Integer.toHexString(prim.getIntHexadecimalValue());
                }
                case BOOLEAN_VALUE: {
                    return String.valueOf(prim.getBooleanValue());
                }
                case FLOAT_VALUE: {
                    return String.valueOf(prim.getFloatValue());
                }
                case COLOR_ARGB4_VALUE: {
                    return String.format("#%04x", prim.getColorArgb4Value());
                }
                case COLOR_ARGB8_VALUE: {
                    return String.format("#%08x", prim.getColorArgb8Value());
                }
                case COLOR_RGB4_VALUE: {
                    return String.format("#%03x", prim.getColorRgb4Value());
                }
                case COLOR_RGB8_VALUE: {
                    return String.format("#%06x", prim.getColorRgb8Value());
                }
                case DIMENSION_VALUE: {
                    return XmlGenUtils.decodeComplex(prim.getDimensionValue(), false);
                }
                case FRACTION_VALUE: {
                    return XmlGenUtils.decodeComplex(prim.getDimensionValue(), true);
                }
            }
            return "";
        }
        if (i15.hasRef()) {
            Resources.Reference ref = i15.getRef();
            Object value = ref.getName();
            if (((String)value).isEmpty()) {
                value = "id/" + ref.getId();
            }
            return "@" + (String)value;
        }
        if (i15.hasFile()) {
            return i15.getFile().getPath();
        }
        return "";
    }
}

