/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.plugins;

import jadx.gui.plugins.context.ITreeInputCategory;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeInputsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TreeInputsHelper.class);
    private final List<CategoryData> categoryData;
    private List<Path> simpleFiles;

    public TreeInputsHelper(MainWindow mainWindow) {
        this.categoryData = mainWindow.getWrapper().getGuiPluginsContext().getTreeInputCategories().stream().map(x$0 -> new CategoryData((ITreeInputCategory)x$0)).collect(Collectors.toList());
    }

    public void processInputs(List<Path> files) {
        this.simpleFiles = new ArrayList<Path>(files.size());
        for (Path file2 : files) {
            boolean added = false;
            for (CategoryData data : this.categoryData) {
                if (!data.filesFilter(file2)) continue;
                added = true;
                break;
            }
            if (added) continue;
            this.simpleFiles.add(file2);
        }
    }

    public List<JNode> getCustomNodes() {
        return this.categoryData.stream().filter(CategoryData::notEmpty).map(CategoryData::buildInputNode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Path> getSimpleFiles() {
        return this.simpleFiles;
    }

    private static final class CategoryData {
        private final ITreeInputCategory provider;
        private final List<Path> collectedFiles = new ArrayList<Path>();

        private CategoryData(ITreeInputCategory provider) {
            this.provider = provider;
        }

        public boolean filesFilter(Path file2) {
            try {
                if (this.provider.filesFilter(file2)) {
                    this.collectedFiles.add(file2);
                    return true;
                }
            }
            catch (Exception e15) {
                LOG.error("Failed to filter input files", e15);
            }
            return false;
        }

        @Nullable
        public JNode buildInputNode() {
            try {
                return this.provider.buildInputNode(this.collectedFiles);
            }
            catch (Exception e15) {
                LOG.error("Failed to build custom input node", e15);
                return null;
            }
        }

        public boolean notEmpty() {
            return !this.collectedFiles.isEmpty();
        }
    }
}

