/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Rectangle;
import java.io.IOException;

public class RectangleTypeAdapter {
    private static final TypeAdapter<Rectangle> SINGLETON = new TypeAdapter<Rectangle>(){

        @Override
        public void write(JsonWriter out, Rectangle value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.beginObject();
                out.name("x").value(value.getX());
                out.name("y").value(value.getY());
                out.name("width").value(value.getWidth());
                out.name("height").value(value.getHeight());
                out.endObject();
            }
        }

        @Override
        public Rectangle read(JsonReader in4) throws IOException {
            if (in4.peek() == JsonToken.NULL) {
                in4.nextNull();
                return null;
            }
            in4.beginObject();
            Rectangle rectangle = new Rectangle();
            block12: while (in4.hasNext()) {
                String name;
                switch (name = in4.nextName()) {
                    case "x": {
                        rectangle.x = in4.nextInt();
                        continue block12;
                    }
                    case "y": {
                        rectangle.y = in4.nextInt();
                        continue block12;
                    }
                    case "width": {
                        rectangle.width = in4.nextInt();
                        continue block12;
                    }
                    case "height": {
                        rectangle.height = in4.nextInt();
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unknown field in Rectangle: " + name);
            }
            in4.endObject();
            return rectangle;
        }
    };

    public static TypeAdapter<Rectangle> singleton() {
        return SINGLETON;
    }

    private RectangleTypeAdapter() {
    }
}

