/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.gui.utils.NLS;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateManager {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateManager.class);
    private static final String CERTIFICATE_TYPE_NAME = "X.509";
    private final Certificate cert;
    private X509Certificate x509cert;

    public static String decode(InputStream in4) {
        StringBuilder strBuild = new StringBuilder();
        Collection<? extends Certificate> certificates = CertificateManager.readCertificates(in4);
        if (certificates != null) {
            for (Certificate certificate : certificates) {
                CertificateManager certificateManager = new CertificateManager(certificate);
                strBuild.append(certificateManager.generateText());
            }
        }
        return strBuild.toString();
    }

    static Collection<? extends Certificate> readCertificates(InputStream in4) {
        try {
            CertificateFactory cf5 = CertificateFactory.getInstance(CERTIFICATE_TYPE_NAME);
            return cf5.generateCertificates(in4);
        }
        catch (Exception e15) {
            LOG.error("Certificate read error", e15);
            return Collections.emptyList();
        }
    }

    public CertificateManager(Certificate cert) {
        this.cert = cert;
        String type = cert.getType();
        if (type.equals(CERTIFICATE_TYPE_NAME) && cert instanceof X509Certificate) {
            this.x509cert = (X509Certificate)cert;
        }
    }

    public String generateHeader() {
        StringBuilder builder = new StringBuilder();
        CertificateManager.append(builder, NLS.str("certificate.cert_type"), this.x509cert.getType());
        CertificateManager.append(builder, NLS.str("certificate.serialSigVer"), Integer.valueOf(this.x509cert.getVersion()).toString());
        CertificateManager.append(builder, NLS.str("certificate.serialNumber"), "0x" + this.x509cert.getSerialNumber().toString(16));
        Principal subjectDN = this.x509cert.getSubjectDN();
        CertificateManager.append(builder, NLS.str("certificate.cert_subject"), subjectDN.getName());
        CertificateManager.append(builder, NLS.str("certificate.serialValidFrom"), this.x509cert.getNotBefore().toString());
        CertificateManager.append(builder, NLS.str("certificate.serialValidUntil"), this.x509cert.getNotAfter().toString());
        return builder.toString();
    }

    public String generateSignature() {
        StringBuilder builder = new StringBuilder();
        CertificateManager.append(builder, NLS.str("certificate.serialSigType"), this.x509cert.getSigAlgName());
        CertificateManager.append(builder, NLS.str("certificate.serialSigOID"), this.x509cert.getSigAlgOID());
        return builder.toString();
    }

    public String generateFingerprint() {
        StringBuilder builder = new StringBuilder();
        try {
            CertificateManager.append(builder, NLS.str("certificate.serialMD5"), CertificateManager.getThumbPrint(this.x509cert, "MD5"));
            CertificateManager.append(builder, NLS.str("certificate.serialSHA1"), CertificateManager.getThumbPrint(this.x509cert, "SHA-1"));
            CertificateManager.append(builder, NLS.str("certificate.serialSHA256"), CertificateManager.getThumbPrint(this.x509cert, "SHA-256"));
        }
        catch (Exception e15) {
            LOG.error("Failed to parse fingerprint", e15);
        }
        return builder.toString();
    }

    public String generatePublicKey() {
        PublicKey publicKey = this.x509cert.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            return this.generateRSAPublicKey();
        }
        if (publicKey instanceof DSAPublicKey) {
            return this.generateDSAPublicKey();
        }
        return "";
    }

    String generateRSAPublicKey() {
        RSAPublicKey pub = (RSAPublicKey)this.cert.getPublicKey();
        StringBuilder builder = new StringBuilder();
        CertificateManager.append(builder, NLS.str("certificate.serialPubKeyType"), pub.getAlgorithm());
        CertificateManager.append(builder, NLS.str("certificate.serialPubKeyExponent"), pub.getPublicExponent().toString(10));
        CertificateManager.append(builder, NLS.str("certificate.serialPubKeyModulusSize"), Integer.toString(pub.getModulus().toString(2).length()));
        CertificateManager.append(builder, NLS.str("certificate.serialPubKeyModulus"), pub.getModulus().toString(10));
        return builder.toString();
    }

    String generateDSAPublicKey() {
        DSAPublicKey pub = (DSAPublicKey)this.cert.getPublicKey();
        StringBuilder builder = new StringBuilder();
        CertificateManager.append(builder, NLS.str("certificate.serialPubKeyType"), pub.getAlgorithm());
        CertificateManager.append(builder, NLS.str("certificate.serialPubKeyY"), pub.getY().toString(10));
        return builder.toString();
    }

    public String generateTextForX509() {
        StringBuilder builder = new StringBuilder();
        if (this.x509cert != null) {
            builder.append(this.generateHeader());
            builder.append('\n');
            builder.append(this.generatePublicKey());
            builder.append('\n');
            builder.append(this.generateSignature());
            builder.append('\n');
            builder.append(this.generateFingerprint());
        }
        return builder.toString();
    }

    public String generateText() {
        StringBuilder str = new StringBuilder();
        String type = this.cert.getType();
        if (type.equals(CERTIFICATE_TYPE_NAME)) {
            str.append(this.generateTextForX509());
        } else {
            str.append(this.cert.toString());
        }
        return str.toString();
    }

    static void append(StringBuilder str, String name, String value) {
        str.append(name).append(": ").append(value).append('\n');
    }

    public static String getThumbPrint(X509Certificate cert, String type) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md5 = MessageDigest.getInstance(type);
        byte[] der = cert.getEncoded();
        md5.update(der);
        byte[] digest = md5.digest();
        return CertificateManager.hexify(digest);
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder buf = new StringBuilder(bytes.length * 3);
        for (byte aByte : bytes) {
            buf.append(hexDigits[(aByte & 0xF0) >> 4]);
            buf.append(hexDigits[aByte & 0xF]);
            buf.append(' ');
        }
        return buf.toString();
    }
}

