/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.popupmenu;

import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.SetValueDialog;
import jadx.gui.ui.panel.JDebuggerPanel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarTreePopupMenu
extends JPopupMenu {
    private static final Logger LOG = LoggerFactory.getLogger(VarTreePopupMenu.class);
    private static final long serialVersionUID = -1111111202103170724L;
    private final MainWindow mainWindow;
    private JDebuggerPanel.ValueTreeNode valNode;

    public VarTreePopupMenu(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.addItems();
    }

    public void show(JDebuggerPanel.ValueTreeNode treeNode, Component invoker, int x15, int y15) {
        this.valNode = treeNode;
        super.show(invoker, x15, y15);
    }

    private void addItems() {
        JMenuItem copyValItem = new JMenuItem(new AbstractAction(NLS.str("debugger.popup_copy_value")){
            private static final long serialVersionUID = -1111111202103171118L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                String val = VarTreePopupMenu.this.valNode.getValue();
                if (val != null) {
                    if (val.startsWith("\"") && val.endsWith("\"")) {
                        val = val.substring(1, val.length() - 1);
                    }
                    StringSelection stringSelection = new StringSelection(val);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        JMenuItem setValItem = new JMenuItem(new AbstractAction(NLS.str("debugger.popup_set_value")){
            private static final long serialVersionUID = -1111111202103171119L;

            @Override
            public void actionPerformed(ActionEvent e15) {
                new SetValueDialog(VarTreePopupMenu.this.mainWindow, VarTreePopupMenu.this.valNode).setVisible(true);
            }
        });
        JMenuItem zeroItem = new JMenuItem(new AbstractAction(NLS.str("debugger.popup_change_to_zero")){
            private static final long serialVersionUID = -1111111202103171120L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    VarTreePopupMenu.this.mainWindow.getDebuggerPanel().getDbgController().modifyRegValue(VarTreePopupMenu.this.valNode, ArgType.INT, 0);
                }
                catch (Exception e15) {
                    LOG.error("Change to zero failed", e15);
                    UiUtils.showMessageBox(VarTreePopupMenu.this.mainWindow, e15.getMessage());
                }
            }
        });
        JMenuItem oneItem = new JMenuItem(new AbstractAction(NLS.str("debugger.popup_change_to_one")){
            private static final long serialVersionUID = -1111111202103171121L;

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    VarTreePopupMenu.this.mainWindow.getDebuggerPanel().getDbgController().modifyRegValue(VarTreePopupMenu.this.valNode, ArgType.INT, 1);
                }
                catch (Exception e15) {
                    LOG.error("Change to one failed", e15);
                    UiUtils.showMessageBox(VarTreePopupMenu.this.mainWindow, e15.getMessage());
                }
            }
        });
        this.add(copyValItem);
        this.add(new JPopupMenu.Separator());
        this.add(setValItem);
        this.add(zeroItem);
        this.add(oneItem);
        this.add(zeroItem);
    }
}

