/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.ui.action.JNodeAction;
import jadx.gui.ui.action.JadxGuiAction;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.JNodePopupListener;
import jadx.gui.utils.shortcut.ShortcutsController;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;

public class JNodePopupBuilder {
    private final JPopupMenu menu;
    private final JNodePopupListener popupListener;
    private final ShortcutsController shortcutsController;

    public JNodePopupBuilder(CodeArea codeArea, JPopupMenu popupMenu, ShortcutsController shortcutsController) {
        this.shortcutsController = shortcutsController;
        this.menu = popupMenu;
        this.popupListener = new JNodePopupListener(codeArea);
        popupMenu.addPopupMenuListener(this.popupListener);
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public void add(JNodeAction nodeAction) {
        if (nodeAction.getActionModel() != null) {
            this.shortcutsController.bindImmediate(nodeAction);
        }
        this.menu.add(nodeAction);
        this.popupListener.addActions(nodeAction);
    }

    public void add(JadxGuiAction action) {
        if (action.getActionModel() != null) {
            this.shortcutsController.bindImmediate(action);
        }
        this.menu.add(action);
        if (action instanceof PopupMenuListener) {
            this.menu.addPopupMenuListener((PopupMenuListener)((Object)action));
        }
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }
}

