/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.JavaNode;
import jadx.api.gui.tree.ITreeNode;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.resources.ResourceContentType;
import jadx.core.utils.ListUtils;
import jadx.gui.treemodel.JClass;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JNode
extends DefaultMutableTreeNode
implements ITreeNode,
Comparable<JNode> {
    private static final long serialVersionUID = -5154479091781041008L;
    private static final Comparator<JNode> COMPARATOR = Comparator.comparing(JNode::makeLongString).thenComparingInt(JNode::getPos);

    public abstract JClass getJParent();

    public JClass getRootClass() {
        return null;
    }

    public JavaNode getJavaNode() {
        return null;
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return null;
    }

    public boolean hasContent() {
        return false;
    }

    @Nullable
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        return null;
    }

    public String getSyntaxName() {
        return "text/plain";
    }

    public ICodeInfo getCodeInfo() {
        return ICodeInfo.EMPTY;
    }

    public ResourceContentType getContentType() {
        return ResourceContentType.CONTENT_TEXT;
    }

    public boolean isEditable() {
        return false;
    }

    @Override
    public String getName() {
        JavaNode javaNode = this.getJavaNode();
        if (javaNode == null) {
            return null;
        }
        return javaNode.getName();
    }

    public boolean supportsQuickTabs() {
        return true;
    }

    @Nullable
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return null;
    }

    @Override
    public String getID() {
        return this.makeString();
    }

    public abstract String makeString();

    public String makeStringHtml() {
        return this.makeString();
    }

    public String makeDescString() {
        return null;
    }

    public boolean hasDescString() {
        return false;
    }

    public String makeLongString() {
        return this.makeString();
    }

    public String makeLongStringHtml() {
        return this.makeLongString();
    }

    public boolean disableHtml() {
        return true;
    }

    public int getPos() {
        JavaNode javaNode = this.getJavaNode();
        if (javaNode == null) {
            return -1;
        }
        return javaNode.getDefPos();
    }

    public String getTooltip() {
        return this.makeLongStringHtml();
    }

    @Nullable
    public JNode searchNode(Predicate<JNode> filter) {
        Enumeration<TreeNode> en4 = this.children();
        while (en4.hasMoreElements()) {
            JNode node = (JNode)en4.nextElement();
            if (!filter.test(node)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public JNode searchDepthNode(Predicate<JNode> filter) {
        Enumeration<TreeNode> en4 = this.breadthFirstEnumeration();
        while (en4.hasMoreElements()) {
            JNode node = (JNode)en4.nextElement();
            if (!filter.test(node)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public JNode removeNode(Predicate<JNode> filter) {
        Enumeration<TreeNode> en4 = this.children();
        while (en4.hasMoreElements()) {
            JNode node = (JNode)en4.nextElement();
            if (!filter.test(node)) continue;
            this.remove(node);
            return node;
        }
        return null;
    }

    public List<TreeNode> childrenList() {
        return ListUtils.enumerationToList(this.children());
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        return COMPARATOR.compare(this, other);
    }

    @Override
    public String toString() {
        return this.makeString();
    }
}

