/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.quark;

import jadx.gui.plugins.quark.QuarkManager;
import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkDialog
extends JDialog {
    private static final long serialVersionUID = 4855753773520368215L;
    private static final Logger LOG = LoggerFactory.getLogger(QuarkDialog.class);
    private final transient JadxSettings settings;
    private final transient MainWindow mainWindow;
    private final List<Path> files;
    private JComboBox<Path> fileSelectCombo;

    public QuarkDialog(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.settings = mainWindow.getSettings();
        this.files = this.filterOpenFiles(mainWindow);
        if (this.files.isEmpty()) {
            UiUtils.errorMessage(mainWindow, "Quark is unable to analyze loaded files");
            LOG.error("Quark: The files cannot be analyzed: {}", (Object)mainWindow.getProject().getFilePaths());
            return;
        }
        this.initUI();
    }

    private List<Path> filterOpenFiles(MainWindow mainWindow) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.{apk,dex}");
        return mainWindow.getProject().getFilePaths().stream().filter(matcher::matches).collect(Collectors.toList());
    }

    private void initUI() {
        JLabel description = new JLabel("Analyzing apk using Quark-Engine");
        JLabel selectApkText = new JLabel("Select Apk/Dex");
        description.setAlignmentX(0.5f);
        this.fileSelectCombo = new JComboBox<Path>(this.files.toArray(new Path[0]));
        this.fileSelectCombo.setRenderer((list2, value, index, isSelected, cellHasFocus) -> new NodeLabel(value.getFileName().toString()));
        JPanel textPane = new JPanel();
        textPane.add(description);
        JPanel selectApkPanel = new JPanel();
        selectApkPanel.add(selectApkText);
        selectApkPanel.add(this.fileSelectCombo);
        JPanel buttonPane = new JPanel();
        JButton start = new JButton("Start");
        JButton close = new JButton("Close");
        close.addActionListener(event -> this.close());
        start.addActionListener(event -> this.startQuarkTasks());
        buttonPane.add(start);
        buttonPane.add(close);
        this.getRootPane().setDefaultButton(close);
        JPanel centerPane = new JPanel();
        centerPane.add(selectApkPanel);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)textPane, "First");
        contentPane.add(centerPane);
        contentPane.add((Component)buttonPane, "Last");
        this.setTitle("Quark Engine");
        this.pack();
        if (!this.mainWindow.getSettings().loadWindowPos(this)) {
            this.setSize(300, 140);
        }
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        UiUtils.addEscapeShortCutToDispose(this);
    }

    private void startQuarkTasks() {
        Path apkFile = (Path)this.fileSelectCombo.getSelectedItem();
        new QuarkManager(this.mainWindow, apkFile).start();
        this.close();
    }

    private void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.settings.saveWindowPos(this);
        super.dispose();
    }
}

